/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;

/**
 * A Stats interface to expose information about the JVM Runtime
 * @since 8.1
 */

public interface JVMRuntimeStats extends Stats {
    
    /**
     * Returns the name representing the running JVM
     * @return StringStatistic  the name of the running JVM
     */
    public StringStatistic getName();
    
    
    /**
     * Returns the JVM implementation name
     * @return StringStatistic  JVM implementation name
     */
    public StringStatistic getVmName();
    
    /**
     * Returns the JVM implementation vendor
     * @return StringStatistic  JVM implementation vendor
     */
    public StringStatistic getVmVendor();
    
    /**
     * Returns the JVM implementation version
     * @return StringStatistic JVM implementation version
     */
    public StringStatistic getVmVersion();
    
    /**
     * Returns the JVM specification name
     * @return StringStatistic  JVM specification name
     */
    public StringStatistic getSpecName();
    
    /**
     * Returns the JVM specification vendor
     * @return StringStatistic  JVM specification vendor
     */
    public StringStatistic getSpecVendor();
    
    /**
     * Returns the JVM specification version
     * @return StringStatistic  JVM specification version
     */
    public StringStatistic getSpecVersion();
    
    /**
     * Returns the management spec version implemented by the 
     * JVM
     * @return  StringStatistic Management specification version
     */
    public StringStatistic getManagementSpecVersion();
    
    /**
     * Returns the classpath that is used by the system class loader
     * to search for class files
     * @return StringStatistic  Java class path
     */
    public StringStatistic getClassPath();
    
    /**
     * returns the Java library path
     * @return StringStatistic  Java library path
     */
    public StringStatistic getLibraryPath();
    
    /**
     * Returns the classpath that is used by the bootstrap class loader
     * to search for class files
     * @return StringStatistic  the boot classpath
     */
    public StringStatistic getBootClasspath();
    
    /**
     * Returns the input arguments passed to the JVM. Does not include
     * the arguments to the main method
     * @return StringStatistic  arguments to the JVM
     */
    public StringStatistic getInputArguments();
    
    /**
     * Returns the uptime of the JVM in milliseconds
     * @return CountStatistic   Uptime in milliseconds
     */
    public CountStatistic getUptime();
    
    
}
