/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;

/**
 * A Stats interface, to expose the monitoring information 
 * about the JVM memory subsystem. This interfaces exposes
 * the memory usage information for the heap and the non-heap
 * areas of the memory subsystem.
 * @since 8.1
 */
public interface JVMMemoryStats extends Stats {
    
    /**
     * Returns the approximate number of objects, that are
     * pending finalization.
     * @return CountStatistic   Objects pending finalization
     */
    public CountStatistic getObjectPendingFinalizationCount();
    
    /**
     * Returns the size of the heap initially requested by the JVM
     * @return CountStatistic initial heap size in bytes
     */
    public CountStatistic getInitHeapSize();
    
    /**
     * Returns the size of the heap currently in use
     * @return CountStatistic current heap usage in bytes
     */
    public CountStatistic getUsedHeapSize();
    
    /**
     * Returns the maximum amount of memory in bytes that can be used
     * for memory management
     * @return CountStatistic maximum heap size in bytes
     */
    public CountStatistic getMaxHeapSize();
    
    /**
     * Returns the amount of memory in bytes that is committed
     * for the JVM to use
     * @return CountStatistic memory committed for the jvm in bytes
     */
    public CountStatistic getCommittedHeapSize();
    
    /**
     * Returns the size of the non=heap area initially 
     * requested by the JVM
     * @return CountStatistic initial size of the non-heap area in bytes
     */
    public CountStatistic getInitNonHeapSize();
    
    /**
     * Returns the size of the non-heap area currently in use
     * @return CountStatistic current usage of the non-heap area in bytes
     */
    public CountStatistic getUsedNonHeapSize();
    
    /**
     * Returns the maximum amount of memory in bytes that can be used
     * for memory management
     * @return CountStatistic maximum non-heap area size in bytes
     */
    public CountStatistic getMaxNonHeapSize();
    
    /**
     * Returns the amount of memory in bytes that is committed
     * for the JVM to use
     * @return CountStatistic memory committed for the jvm in bytes
     */
    public CountStatistic getCommittedNonHeapSize();
    
}
