/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * $Id: ConnectionPoolStats.java,v 1.2 2005/12/25 03:52:11 tcfujii Exp $
 * $Date: 2005/12/25 03:52:11 $
 * $Revision: 1.2 $
 *
 */

package com.sun.enterprise.admin.monitor.stats;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;

/** 
 * A Stats interface to represent the statistical data exposed by a Connection 
 * Pool. All the Connection Pool implementations should expose statistical data 
 * by implementing this interface.
 */

public interface ConnectionPoolStats extends Stats {
    
    /**
     * Statistic to represent the Connection Usage
     * In addition to information about the number of connections being
     * used currently, this also contains information about the 
     * Maximum number of connections that were used(High Watermark)
     * @return RangeStatistic
     */
    public RangeStatistic getNumConnUsed();
    
    /*
     * represents the number of free connections in the pool.
     * @return CountStatistic
     */
    //public CountStatistic getNumConnFree() ;
    
    /**
     * represents the number of connections that failed validation
     * @return CountStatistic
     */
    public CountStatistic getNumConnFailedValidation() ;
   
    /**
     * represents the number of connection requests that timed out
     * @return CountStatistic
     */
    public CountStatistic getNumConnTimedOut();
	
	/**
     * Indicates the number of free connections in the pool in addition
	 * to their high and low watermarks.
     * @return RangeStatistic
	 */
	 public RangeStatistic getNumConnFree();
     
	
	/**
	 * Indicates the average wait time of connections, for successful
	 * connection request attempts to the connector connection pool
	 * @return CountStatistic
	 */
	public CountStatistic getAverageConnWaitTime();
	
	/**
	 * Indicates the number of connection requests in the queue waiting 
	 * to be serviced
	 * @return CountStatistic
	 */
	public CountStatistic getWaitQueueLength();
	
	/**
	 * Indicates the longest, shortest wait times of connection 
	 * requests. The current value indicates the wait time of 
	 * the last request that was serviced by the pool.
	 * @return RangeStatistic
	 */
	public RangeStatistic getConnRequestWaitTime();
	
	/** 
	 * indicates the number of physical EIS/JDBC connections that were created, 
     * since the last reset
	 * @return CountStatistic
	 */
	public CountStatistic getNumConnCreated();
	
	/**
	 * indicates the number of physical EIS/JDBC connections that were destroyed
     * , since the last reset
	 * @return CountStatistic
	 */
	public CountStatistic getNumConnDestroyed();

    /**
     * indicates the number of logical EIS/JDBC connections that were acquired 
     * from the pool, since the last reset
     * @return CountStatistic
     * @since 8.1
     */
    public CountStatistic getNumConnAcquired();
    
    /**
     * indicates the number of logical EIS/JDBC connections that were released 
     * to the pool, since the last reset
     * @return CountStatistic
     * @since 8.1
     */
    public CountStatistic getNumConnReleased();      

    /**
     * Indicates the number of connections that were successfully matched by 
     * the Managed Connection Factory.
     * 
     * @return CountStatistic
     * @since 9.0
     */
    public CountStatistic getNumConnSuccessfullyMatched();
 
    /**
     * Indicates the number of connections that were rejected by the
     * Managed Connection Factory during matching.
     * 
     * @return CountStatistic
     * @since 9.0
     */
    public CountStatistic getNumConnNotSuccessfullyMatched(); 
}
