/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/util/jmx/Attic/ObjectNameQueryMBeanImpl.java,v 1.4 2006/03/09 20:30:32 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:32 $
 */
package com.sun.appserv.management.util.jmx;

import java.util.Set;

import javax.management.StandardMBean;
import javax.management.ObjectName;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;

import javax.management.MalformedObjectNameException;
import javax.management.MBeanRegistration;

/**
	An MBean implementing ObjectNameQueryMBean
 */
public class ObjectNameQueryMBeanImpl
	extends StandardMBean
	implements ObjectNameQueryMBean, MBeanRegistration
{
	private MBeanServerConnection		mConn;
	private ObjectNameQueryImpl			mImpl;
	
		public
	ObjectNameQueryMBeanImpl()
		throws NotCompliantMBeanException
	{
		super( ObjectNameQueryMBean.class );
	}
	
		public Set<ObjectName>
	matchAll( ObjectName startingSetPattern, String [] regexNames, String [] regexValues )
				throws MalformedObjectNameException, java.io.IOException
	{
		final Set<ObjectName>	candidates	= JMXUtil.queryNames( mConn, startingSetPattern, null );
		
		return( mImpl.matchAll( candidates, regexNames, regexValues ) );
	}
	
		public Set<ObjectName>
	matchAll( Set<ObjectName> startingSet, String [] regexNames, String [] regexValues )
	{
		return( mImpl.matchAll( startingSet, regexNames, regexValues ) );
	}
				
		public Set<ObjectName>
	matchAny( ObjectName startingSetPattern, String [] regexNames, String [] regexValues )
				throws MalformedObjectNameException, java.io.IOException
	{
		final Set<ObjectName>	candidates	= JMXUtil.queryNames( mConn, startingSetPattern, null );
		
		return( mImpl.matchAny( candidates, regexNames, regexValues ) );
	}
				
		public Set<ObjectName>
	matchAny( Set<ObjectName> startingSet, String [] regexNames, String [] regexValues )
	{
		return( mImpl.matchAny( startingSet, regexNames, regexValues ) );
	}
	
	
	
		public ObjectName
	preRegister( final MBeanServer server, final ObjectName name)
	{
		mConn		= server;
		
		mImpl		= new ObjectNameQueryImpl( );
		return( name );
	}
	
		public void
	postRegister( Boolean registrationDone )
	{
	}
	
		public void
	preDeregister()
	{
		// nothing to do
	}
		public void
	postDeregister()
	{
		// nothing to do
	}

}






