/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/util/jmx/Attic/JMXConnectorConnectionSource.java,v 1.3 2005/12/25 03:51:22 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:51:22 $
 */

package com.sun.appserv.management.util.jmx;

import java.io.IOException;

import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;

import com.sun.appserv.management.client.ConnectionSource;


/**
	A ConnectionSource for in-process access where the MBeanServer is actually
	known and where later access to it may be desired.
 */
public final class JMXConnectorConnectionSource
	implements ConnectionSource
{
	protected JMXConnector	mJMXConnector;
	
		public
	JMXConnectorConnectionSource( final JMXConnector connector )
		throws IOException
	{
		if ( connector == null )
		{
			throw new IllegalArgumentException();
		}
		
		mJMXConnector	= connector;
		
		// make sure it's good, now
		getMBeanServerConnection( false );
	}
	
	
	
		public MBeanServerConnection
	getExistingMBeanServerConnection( )
	{
		try
		{
			return( mJMXConnector.getMBeanServerConnection() );
		}
		catch( IOException e )
		{
		}
		return( null );
	}
	
		public MBeanServerConnection
	getMBeanServerConnection( boolean forceNew )
		throws IOException
	{
		return( mJMXConnector.getMBeanServerConnection() );
	}
	
	/**
		@return the existing JMXConnector 
	 */
		public JMXConnector
	getJMXConnector( final boolean forceNew )
		throws IOException
	{
		// all we have is what is already present; no way to create a new one
		return( mJMXConnector );
	}
}
