/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: AltServletStats.java,v 1.4 2005/12/25 03:51:11 tcfujii Exp $
 * $Date: 2005/12/25 03:51:11 $
 * $Revision: 1.4 $
 *
 */

package com.sun.appserv.management.monitor.statistics;

import javax.management.j2ee.statistics.ServletStats;
import javax.management.j2ee.statistics.Stats;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.TimeStatistic;

/** 
	Defines additional Sun ONE Application Server specific statistics 
	ServletStats interface.
	Extension of javax.management.j2ee.statistics.ServletStats.
	@see com.sun.appserv.management.j2ee.Servlet
 */
public interface AltServletStats extends ServletStats
{
    /*
      CAUTION: if adding something here, modify
      com.sun.enterprise.management.monitor.ServletMonitorImpl.getStatisticsFromDelegate()
      */
      
    /**
     * The errorCount represents the number of cases where the response 
     * code was >= 400
     * @return CountStatistic
     */
    public CountStatistic getErrorCount();
    
    /**
        @since AppServer 9.0
     */
    public CountStatistic getRequestCount();
    
    /**
        @since AppServer 9.0
     */
    public CountStatistic getProcessingTime();
    
    /**
        @since AppServer 9.0
     */
    public CountStatistic getMaxTime();
    
    /**
        @since AppServer 9.0
     */
    public TimeStatistic getServiceTime();
}
