/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.ext.logging;

import java.util.Map;
import java.util.List;
import java.util.HashMap;
import java.util.Date;

import java.util.logging.Level;

import java.io.Serializable;

import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.OpenDataException;

import com.sun.appserv.management.util.jmx.OpenMBeanUtil;
import com.sun.appserv.management.util.misc.ArrayUtil;
import com.sun.appserv.management.util.misc.ObjectUtil;
import com.sun.appserv.management.util.stringifier.ArrayStringifier;

/**
    <b>INTERNAL USE ONLY--not part of the API</b>
	@since AS 9.0
 */
public final class LogQueryResultImpl
    implements LogQueryResult
{
    private String[]         mFieldNames;
    private LogQueryEntry[]  mEntries;
    
        public
    LogQueryResultImpl(
        final String[]          fieldNames,
        final LogQueryEntry[]   entries )
    {
        mFieldNames   = fieldNames;
        mEntries      = entries;
    }
    
    /**
        Instantiate using result from {@link Logging#queryServerLog}.
        The first Object[] is a String[] of the field names.
        Subsequent Object[] are the data values.
     */
        public 
    LogQueryResultImpl( final List<Serializable[]> records )
    {
        mFieldNames   = (String[])records.get( 0 );
        
        mEntries    = new LogQueryEntry[ records.size() - 1 ];
        for( int i = 1; i < mEntries.length; ++i )
        {
            mEntries[ i ]   = new LogQueryEntryImpl( records.get( i ) );
        }
    }
    
        public String[]
    getFieldNames()
    {
        return mFieldNames;
    }
    
        public LogQueryEntry[]
    getEntries()
    {
        return mEntries;
    }
    
    private static final String    FIELD_DELIM = "\t";
    private static final String    NEWLINE = System.getProperty( "line.separator" );;
    /**
        Output a tab-delimited String with a header line. Each
        subsequent line represents another log record.
     */
        public String
    toString()
    {
        final StringBuilder builder = new StringBuilder();
        
        for( final String s : getFieldNames() )
        {
            builder.append( s );
            builder.append( FIELD_DELIM );
        }
        builder.replace( builder.length() - 1, builder.length(), NEWLINE );
        
        for ( final LogQueryEntry entry : getEntries() )
        {
            final Object[]  fields  = entry.getFields();
            for( final Object o : fields )
            {
                builder.append( o.toString() );
                builder.append( FIELD_DELIM );
            }
            builder.replace( builder.length() - 1, builder.length(), NEWLINE );
        }
        
        return builder.toString();
    }
    
 	    public int
 	hashCode()
 	{
 	    return ObjectUtil.hashCode( getFieldNames(), getEntries() );
 	}
    
        public boolean
    equals( final Object rhs )
    {
        boolean equal   = rhs instanceof LogQueryResult;
        
        if ( equal )
        {
            final LogQueryResult    r   = (LogQueryResult)rhs;
            
            equal   = ArrayUtil.arraysEqual( getFieldNames(), r.getFieldNames() ) &&
                      ArrayUtil.arraysEqual( getEntries(), r.getEntries() );
                        
        }
        
        return equal;
    }
    
 
}





