/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.ext.logging;

import java.util.Collections;
import java.util.Set;

import com.sun.appserv.management.util.misc.GSetUtil;

/**
	Names of log level modules.
	@see Logging
    @since AppServer 9.0
 */
public class LogModuleNames
{
	protected LogModuleNames()	{}
	
	public static final String ROOT_KEY					= "Root";
	public static final String SERVER_KEY				= "Server";
	public static final String EJB_CONTAINER_KEY		= "EJBContainer";
    public static final String CMP_CONTAINER_KEY		= "CMPContainer";
    public static final String MDB_CONTAINER_KEY		= "MDBContainer";
    public static final String WEB_CONTAINER_KEY		= "WebContainer";
    public static final String CLASSLOADER_KEY			= "Classloader";
    public static final String CONFIGURATION_KEY		= "Configuration";
    public static final String NAMING_KEY				= "Naming";
    public static final String SECURITY_KEY				= "Security";
	public static final String JTS_KEY					= "JTS";
	public static final String JTA_KEY					= "JTA";
    public static final String ADMIN_KEY				= "Admin";
    public static final String DEPLOYMENT_KEY			= "Deployment";
    public static final String VERIFIER_KEY				= "Verifier";
    public static final String JAXR_KEY					= "JAXR";
    public static final String JAXRPC_KEY				= "JAXRPC";
    public static final String SAAJ_KEY					= "SAAJ";
    public static final String CORBA_KEY				= "CORBA";
    public static final String JAVAMAIL_KEY				= "Javamail";
    public static final String JMS_KEY					= "JMS";
    public static final String CONNECTOR_KEY			= "Connector";
    public static final String JDO_KEY					= "JDO";
    public static final String CMP_KEY					= "CMP";
    public static final String UTIL_KEY					= "Util";
    public static final String RESOURCE_ADAPTER_KEY		= "ResourceAdapter";
    public static final String SYNCHRONIZATION_KEY		= "Synchronization";
    public static final String NODE_AGENT_KEY			= "NodeAgent";
    
    /**
     */
    public static final Set<String> ALL_NAMES =
        Collections.unmodifiableSet( GSetUtil.newSet( new String[] 
        {
            ROOT_KEY,
            SERVER_KEY,
            EJB_CONTAINER_KEY,
            CMP_CONTAINER_KEY,
            MDB_CONTAINER_KEY,
            WEB_CONTAINER_KEY,
            CLASSLOADER_KEY,
            CONFIGURATION_KEY,
            NAMING_KEY,
            SECURITY_KEY,
            JTS_KEY,
            JTA_KEY,
            ADMIN_KEY,
            DEPLOYMENT_KEY,
            VERIFIER_KEY,
            JAXR_KEY,
            JAXRPC_KEY,
            SAAJ_KEY,
            CORBA_KEY,
            JAVAMAIL_KEY,
            JMS_KEY,
            CONNECTOR_KEY,
            JDO_KEY,
            CMP_KEY,
            UTIL_KEY,
            RESOURCE_ADAPTER_KEY,
            SYNCHRONIZATION_KEY,
            NODE_AGENT_KEY,
        }));
}

