/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

import java.util.Map;

import com.sun.appserv.management.base.XTypes;


/**
	All MBeans that have system Properties must extend this interface.
	<p>
	Properties are always Strings.  Property names are required to be unique.
	
	@see ClusterConfig
	@see ConfigConfig
	@see DomainConfig
	@see ClusteredServerConfig
	@see StandaloneServerConfig
 */
public interface SystemPropertiesAccess
{
	/**
		When a key is required for a system property in a Map,
		its name must consist of this prefix plus the actual name.  When
		accessing a property directly, this prefix must not be used.
	 */
    final static String SYSTEM_PROPERTY_PREFIX = "system-" + PropertiesAccess.PROPERTY_PREFIX;
    
    
	/**
		Get the names of all system properties.
	 */
	public String[]	getSystemPropertyNames( );
	
	
	/**
		@return Map containing all properties, keyed by name
	 */
	public Map<String,String>		getSystemProperties();
	
	/**
		Get the value of a property.
		
		@param propertyName	the name of the property
	 */
	public String	getSystemPropertyValue( String propertyName );
					
	/**
		Set the value of a system property.  The property must already exist.
		The existing description is retained.
		
		@param propertyName	the name of the property
		@param propertyValue	the value of the property
	 */	
	public void		setSystemPropertyValue( String propertyName, String propertyValue );
						
	/**
		Return true if any system properties exist with the specified name.
		
		@param propertyName	the name of the property
	 */
	public boolean	existsSystemProperty( String propertyName );
	
	/**
		Create a new system property.
		
		@param propertyName		the name of the property
		@param propertyValue	the value of the property
	 */
	public void		createSystemProperty( String propertyName, String propertyValue);
	
	/**
		Remove a system property with the specified name. 
		
		@param propertyName	the name of the property
	 */
	public void		removeSystemProperty( String propertyName );
}



