/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;


/**
	 Configuration for the &lt;profiler&gt; element.
*/

public interface ProfilerConfig extends NamedConfigElement, PropertiesAccess, Enabled
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.PROFILER_CONFIG;
	
	public String	getClasspath();
	public void		setClasspath( String classpath );
	public String	getNativeLibraryPath();
	public void		setNativeLibraryPath( String nativeLibraryPath );
	
	
	public String[]	getJVMOptions();
	/**
	 * Overwrites existing jvm options with the new options.
	 * If the intent is to append the new options the caller needs to first get 
	 * the existing jvm options using <a>#getJVMOptions</a>, append new 
	 * options and set the resulting whole using this method.
	 */
	public void		setJVMOptions( String[] jvmOptions );
}
