/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/Attic/JDBCConnectionPoolConfig.java,v 1.6 2005/12/25 03:49:35 tcfujii Exp $
 * $Revision: 1.6 $
 * $Date: 2005/12/25 03:49:35 $
 */

package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;




/**
	 Configuration for the &lt;jdbc-connection-pool&gt; element.
*/

public interface JDBCConnectionPoolConfig
    extends NamedConfigElement, Description, PropertiesAccess, ResourceRefConfigReferent
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE			= XTypes.JDBC_CONNECTION_POOL_CONFIG;
	
	public String	getConnectionValidationMethod();
	public void	setConnectionValidationMethod( String value );

	public String	getDatasourceClassname();
	public void	setDatasourceClassname( String value );

	public boolean	getFailAllConnections();
	public void	setFailAllConnections( boolean value );

	public String	getIdleTimeoutInSeconds();
	public void	setIdleTimeoutInSeconds( String value );

	public boolean	getIsConnectionValidationRequired();
	public void	setIsConnectionValidationRequired( boolean value );

	public boolean	getIsIsolationLevelGuaranteed();
	public void	setIsIsolationLevelGuaranteed( boolean value );

	public String	getMaxPoolSize();
	public void	setMaxPoolSize( String value );

	public String	getMaxWaitTimeInMillis();
	public void	setMaxWaitTimeInMillis( String value );

	public String	getPoolResizeQuantity();
	public void	setPoolResizeQuantity( String value );

	public String	getResType();
	public void	setResType( String value );

	public String	getSteadyPoolSize();
	public void	setSteadyPoolSize( String value );

	public String	getTransactionIsolationLevel();
	/**
		See {@link IsolationValues}.
	 */
	public void	setTransactionIsolationLevel( String value );

	public String	getValidationTableName();
	public void	setValidationTableName( String value );

    /**                            
        A pool with this property set to true returns                 
        non-transactional connections. This connection does not get   
        automatically enlisted with the transaction manager.
        
        @since AppServer 9.0
     */
    public boolean getNonTransactionalConnections();
    
    /**
        @see #getNonTransactionalConnections          
        @since AppServer 9.0
     */
    public void setNonTransactionalConnections( boolean enabled );
    
    /**                                
        A pool with this property set to true, can be used by         
        non-J2EE components (i.e components other than EJBs or        
        Servlets). The returned connection is enlisted automatically  
        with the transaction context obtained from the transaction    
        manager. This property is to enable the pool to be used by    
        non-component callers such as ServletFilters, Lifecycle       
        modules, and 3rd party persistence managers. Standard J2EE    
        components can continue to use such pools. Connections        
        obtained by non-component callers are not automatically       
        cleaned at the end of a transaction by the container. They    
        need to be explicitly closed by the the caller.               
        
        @since AppServer 9.0
     */
    public boolean getAllowNonComponentCallers();
    
    /**
        @see #getAllowNonComponentCallers          
        @since AppServer 9.0
     */
    public void setAllowNonComponentCallers( boolean enabled );



}
