/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.config;

import java.util.Map;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.XTypes;

/**
 * Configuration for the &lt;group-management-service&gt; for a &lt;config&gt; in
 * a domain. This element controls the behavior of the group management service
 * used for cluster monitoring and failure detection.
 * @since Appserver 9.0
*/

public interface GroupManagementServiceConfig
    extends AMX, ConfigElement, PropertiesAccess
{
    /** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
    public static final String	J2EE_TYPE    = XTypes.GROUP_MANAGEMENT_SERVICE_CONFIG;

    /** Return the FD protocol tries.
     *  This is the maximum number of attempts to try before GMS confirms that a  
     *  failure is suspected in the group.
     *  @return positive integer specifying the number of such attempts
     */
    public String getFDProtocolMaxTries();
    /** Set the FD protocol tries to the specified positive integer value.
      * Must be a positive integer.
      * @param tries a positive integer specifying the number of attempts
    */
    public void setFDProtocolMaxTries(final String tries);


    public String getFDProtocolTimeoutMillis();
    public void setFDProtocolTimeoutMillis(final String duration);

    public String getMergeProtocolMaxIntervalMillis();
    public void setMergeProtocolMaxIntervalMillis(final String duration);

    public String getMergeProtocolMinIntervalMillis();
    public void setMergeProtocolMinIntervalMillis(final String duration);

    public String getPingProtocolTimeoutMillis();
    public void setPingProtocolTimeoutMillis(final String duration);

    public String getVSProtocolTimeoutMillis();
    public void setVSProtocolTimeoutMillis(final String duration);
}
