/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/mbeanapi/src/java/com/sun/appserv/management/config/Attic/DeployedItemRefConfig.java,v 1.7 2005/12/25 03:49:25 tcfujii Exp $
 * $Revision: 1.7 $
 * $Date: 2005/12/25 03:49:25 $
 */

package com.sun.appserv.management.config;

import com.sun.appserv.management.base.XTypes;


/**
	Represents an &lt;application-ref&gt; element
	found within a &lt;server&gt element.
*/
public interface DeployedItemRefConfig extends RefConfig
{
/** The j2eeType as returned by {@link com.sun.appserv.management.base.AMX#getJ2EEType}. */
	public static final String	J2EE_TYPE	= XTypes.DEPLOYED_ITEM_REF_CONFIG;

    /**
        @return comma-delimited list of virtual servers
     */
    String getVirtualServers();
    
    /**
        See {@link #getVirtualServers}.
     */
    void setVirtualServers(final String virtualServers);

    /**
        <b>EE only</b>
        Return the boolean flag that causes any and all load-balancers using
        this application to consider this application unavailable to
        them. Defaults to unavailable (false).
     */    
    public boolean getLBEnabled();

    /**
        <b>EE only</b>
        Set the boolean flag that causes any and all load-balancers using
        this application to consider this application unavailable to
        them. 
     */    
    public void setLBEnabled(final boolean lbEnabled);
    
    /**
        The time, in minutes, that it takes this application to reach 
        a quiescent state after having been disabled.
        @since AppServer 9.0
     */
    public String   getDisableTimeoutInMinutes();
    
    /**
        @see #getDisableTimeoutInMinutes
        @since AppServer 9.0
     */
    public void     setDisableTimeoutInMinutes( final String timeout );
}
