/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.client.handler;

import java.lang.reflect.Method;

import java.util.List;

import java.io.Serializable;
import java.io.IOException;

import javax.management.ObjectName;

import com.sun.appserv.management.client.ConnectionSource;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Util;

import static com.sun.appserv.management.j2ee.J2EETypes.WEB_SERVICE_ENDPOINT;
import static com.sun.appserv.management.base.XTypes.LOGGING;
import static com.sun.appserv.management.base.XTypes.WEB_SERVICE_MGR;

import com.sun.appserv.management.util.misc.TypeCast;
import com.sun.appserv.management.util.jmx.MBeanProxyHandler;

import com.sun.appserv.management.ext.logging.LogQueryResult;
import com.sun.appserv.management.ext.logging.LogQueryResultImpl;


/**
    <b>Private class, not for public use</b>
 */
public final class ConverterHandlerFactory
{
	private ConverterHandlerFactory()   {}
	
	    public static MBeanProxyHandler 
	createHandler(
	    final ConnectionSource  connSource,
	    final ObjectName        objectName )
	    throws IOException
	{
	    final String j2eeType   = Util.getJ2EEType( objectName );
	    
	    AMXProxyHandler	handler = null;
	    
	    if ( LOGGING.equals( j2eeType ) )
	    {
	        handler = new LoggingConverterHandler( connSource, objectName );
	    }
	    else if ( WEB_SERVICE_ENDPOINT.equals( j2eeType ) )
	    {
	        handler = new WebServiceEndpointConverterHandler( connSource, objectName );
	        // getMessagesInHistory()
	    }
	    else if ( WEB_SERVICE_MGR.equals( j2eeType ) )
	    {
	        handler = new WebServiceMgrConverterHandler( connSource, objectName );
	        // getWebServiceEndpointInfo()
	    }
	    else
	    {
    		handler	= new AMXProxyHandler( connSource, objectName );
	    }
	    
	    return handler;
	}
	
}





