/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.client;

import java.security.cert.X509Certificate;
import java.security.cert.CertificateException;
import java.io.IOException;

import javax.net.ssl.X509TrustManager;


/**
	This TrustManager applies no logic as to whether its peer
	certificate is trusted; it trusts all peers.
	This is a security risk, and should be used only for convenience
	in testing or where security is explicitly not an issue.
 */
public final class TrustAnyTrustManager implements X509TrustManager
{
	private static TrustAnyTrustManager		INSTANCE	= null;
	private static TrustAnyTrustManager[]	INSTANCE_ARRAY	= null;
	
	private	TrustAnyTrustManager()	{}
	
	/**
		Get an instance; only one is ever created.
	 */
		public static synchronized TrustAnyTrustManager
	getInstance()
	{
		if ( INSTANCE == null )
		{
			INSTANCE		= new TrustAnyTrustManager();
			INSTANCE_ARRAY	= new TrustAnyTrustManager[] { INSTANCE };
		}
		return( INSTANCE );
	}
	
	/**
		Calls getInstance() and returns an array containing it.
	 */
		public static TrustAnyTrustManager[]
	getInstanceArray()
	{
		getInstance();
		return( INSTANCE_ARRAY );
	}
	
	/**
	    WARNING: does nothing; all clients are always trusted.
	 */
		public void
	checkClientTrusted( X509Certificate[] chain, String authType)
		throws CertificateException
	{
		//trace( "checkClientTrusted, authType = " + authType +
		//	", " + SmartStringifier.toString( chain ) );
	}
	
	/**
	    WARNING: does nothing; all servers are always trusted.
	 */
		public void
	checkServerTrusted( X509Certificate[] chain, String authType)
		throws CertificateException
	{
		//trace( "checkServerTrusted, authType = " + authType +
		//	", " + SmartStringifier.toString( chain ) );
	}
	
	/**
	    @return an empty array.
	 */
		public X509Certificate[]
	getAcceptedIssuers()
	{
		return( new X509Certificate[ 0 ] );
	}
	
		public String
	toString()
	{
		return( "TrustAnyTrustManager--trusts all certificates with no check whatsoever" );
	}
}