/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.appserv.management.base;

import java.util.Map;

import java.io.Serializable;



/**
	Interface which states that the object can be converted into a Map.
	Type parameter <T> must be Object or Serializable.
 */
public interface MapCapable
{
	/**
		To be capable of being serialized and deserialized by generic clients, the following
		rules must be observed for the resulting Map.
		<p>
		The Map itself and any items it references, directly or indirectly must be of a class
		of one of the following:
		<ul>
		<li>any JMX OpenType</li>
		<li>any serializable Collection in java.util whose items meet these rules</li>
		<li>arrays of items whose values meet these rules</li>
		<li>any Throwable found in java. or javax. </li>
		<li>any MapCapable which can produce a Map following these rules</li>
		</ul>
		@return an equivalent Map representing the original object.
	 */
	public Map<String,Serializable> asMap();
	
	/**
		Return the interface that this Map represents
		(the Java classname).
	 */
	public String	getMapClassName();
	
	/**
		The key for the type of Object this Map represents;
		all MapCapable objects will place their classname keyed by this key
		as a String into the Map returned from asMap().
	 */
	public static final String	MAP_CAPABLE_CLASS_NAME_KEY	= "MapCapableClassName";
}








