/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;



/**
 * Pager.java
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.3 $
 */

class Pager {
    private BufferedReader in;
    private BufferedWriter out;
    private int pageLength;
    private String line;

	  /**
	   * Construct an object which will copy one pages worth of lines
	   * at a time from the input to the
	   * the output.
	   *
	   * No attempt is made under any circumstances to close the input
	   * or output.
	   *
	   * @param lines the number of lines in a page. A number less
	   * than 0 means copy all the input to the output.
	   * @param in the source of the copy operation
	   * @param out the destination of the copy operation
	   * @throws IOException if there's a problem reading from, or
	   * writing to, the source or destination
	   */
    
    Pager (int lines, Reader in, Writer out) throws IOException {
        this.in = new BufferedReader(in);
        this.out = new BufferedWriter(out);
        pageLength = lines;
        nextLine();
    }

	  /**
	   * Copy the next page worth of lines from input to output
	   */
    void nextPage() throws IOException {
        for (int i = 0; (pageLength < 0 || i < pageLength) && hasNext(); i++){
            out.write(line);
            out.newLine();
            nextLine();
        }
        out.flush();
    }

	  /**
	   * Indicate if there are lines left to be copied
	   * @return true iff there is at least one line left to be copied
	   */
    boolean hasNext() {
        return line != null;
    }

	  /**
	   * Get the next line and copy it inot the internal buffer so's
	   * we can answer the hasNext() question
	   */
    private void nextLine() throws IOException {
        line = in.readLine();
    }
    
}

