/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.io.OutputStream;

/**
	Base interface for all types of output.
 */
public interface IOutput
{
	/**
		Print a String and then terminate the line.

		@param s - The String to be printed
	 */
	public void println( String s );


	/**
		Print the message and then terminate the line.

		@param msg - object on which toString() will be called.
	 */
	public void println( Object msg );


	/**
		Print a string.

		@param s - The String to be printed
	 */
	public void print( String s );


	/**
		Print the message.

		@param msg - object on which toString() will be called.
	 */
	public void print( Object msg );


	/**
		Closes the underlying output stream.
	 */
	public void	close();


	/**
		Flushes this output stream and forces any buffered output bytes to
		be written out.
	 */
	public void	flush();

}
