/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: ICommandEnvironment.java,v 1.3 2005/12/25 03:47:00 tcfujii Exp $
 */

package com.sun.enterprise.cli.framework;

import java.util.HashMap;

/**
	All the <strong> Subcommands </strong> operate in an Environment which
	itself is set by some other Subcommands. This way, some Subcommands
	<strong> create </strong> an Environment and others <strong> use this
	environment. This interface represents such an Environment that provides
	data required by SubCommands to execute successfully. Any Subcommand can
	override the data set in an Environment (in which it is executed)
	by parsing the arguments supplied on its own command line. Potentially
	there can be multiple Environments. An Environment consists of a
	variable set of Named Options. The Subcommands that create Environment,
	modify this set whenever they are executed. Thus any Option in an
	Environment represents an Environment Setting.
 */
public interface ICommandEnvironment
{
    /**
       Adds Environment.
       Environment have unique names. Successive calls to this method
       with same name would result in replacement of the environment.
    */
    public void setEnvironment(String name, String value);


    /**
       Removes an environment. Does nothing if environment does not exist.
       returns null if environment could not be removed.
    */
    public Object removeEnvironment( String name );

    /**
	Returns an iterator over collection of Option objects.
    */
    public HashMap getEnvironments();

    /**
     *  returns the envrionment value by the given key
     */
    public Object getEnvironmentValue(String key);


    /**
	Returns a string format of the list of options in the environment.
    */
    public String toString();

    /**
	Returns the number of environments
    */
    public int getNumEnvironments();

}
