/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.framework;

import java.util.Vector;

/**
 * The interface class for command objects
 *  @version  $Revision: 1.3 $
 */
public interface ICommand 
{

    /**
     * Returns the name of the command
     */
    public String getName();
    

    /**
     * Sets the name of this command
     */
    public void setName(String name);


    /**
     * Get Usage Text from the command
     */
    public String getUsageText();


    /**
     * Set Usage Text for the command
     */
    public void setUsageText(String usageText);

    /**
     *  Searches for the property with the specified 
     *  key in this properties list
     *  @return the property
     */
    public Object getProperty(String key);


    /** 
     *  Sets the properties of the command
     *  @param key
     *  @param value 
     */
    public void setProperty(String key, Object value);


}

