/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.framework.*;

import com.sun.enterprise.deployment.util.DeploymentProperties;
import com.sun.enterprise.deployment.client.DeploymentFacility;
import com.sun.enterprise.deployment.client.ServerConnectionIdentifier;
import com.sun.enterprise.deployment.client.DeploymentFacilityFactory;
import com.sun.enterprise.deployment.client.JESTarget;
import com.sun.enterprise.deployment.client.JESProgressObject;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import javax.enterprise.deploy.spi.Target;
import com.sun.enterprise.server.Constants;

// jdk imports
import java.io.*;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;


/**
 *  Undeploy command
 *  @version  $Revision: 1.4 $
 */
public class UndeployCommand extends S1ASCommand
{
    private static final String CASCADE_OPTION = "cascade";
    private static final String DROPTABLES_OPTION = "droptables";
    private static final String TARGET_OPTION = "target";

    /**
     *  An abstract method that Executes the command
     *  @throws CommandException
     */
    public void runCommand() 
        throws CommandException, CommandValidationException
    {
        validateOptions();

        DeploymentFacility df = DeploymentFacilityFactory.getDeploymentFacility();
        ServerConnectionIdentifier conn = createServerConnectionIdentifier(
            getHost(), getPort(), getUser(), getPassword());
        df.connect(conn);

        //prepare data
        //Target[] targets = new JESTarget[1];
        final String targetName = getOption(TARGET_OPTION);
        //targets[0] = new JESTarget(targetName, null);
        Map deployOptions = createDeploymentProperties();

        JESProgressObject progressObject = null;
        
        try
        {
            if (df.isConnected())
            {
                CLILogger.getInstance().printDebugMessage("Calling the undeploy with DeployOptions");
                Target[] targets = df.createTargets(new String[]{targetName});
                if (targets == null)
                {
                    //CLILogger.getInstance().printError(getLocalizedString("InvalidTarget"));
                    throw new CommandException(getLocalizedString("InvalidTarget", new Object[] {targetName}));
                }

                progressObject = df.undeploy(targets, getComponentName(), deployOptions);
            } else
            {
                CLILogger.getInstance().printError(
                                   getLocalizedString("CouldNotConnectToDAS"));
            }
        }
        catch (Exception e)
        {
            if (e.getLocalizedMessage() != null)
                CLILogger.getInstance().printDetailMessage(
                    e.getLocalizedMessage());

            throw new CommandException(getLocalizedString(
                "CommandUnSuccessful", new Object[] {name} ), e);
        }

        DeploymentStatus status = df.waitFor(progressObject);
        final String statusString = status.getStageStatusMessage();


        if (status != null &&
            status.getStatus() == DeploymentStatus.FAILURE) {
            throw new CommandException(getLocalizedString(
                "CommandUnSuccessfulWithMsg", new Object[] {name,
                statusString} ));
        } else if (status != null &&
            status.getStatus() == DeploymentStatus.WARNING) {
            CLILogger.getInstance().printDetailMessage(getLocalizedString(
                "CommandSuccessfulWithMsg",
                new Object[] {name, statusString}));
        } else {
            CLILogger.getInstance().printDetailMessage(getLocalizedString(
                "CommandSuccessful", new Object[] {name} ));
        }

    }


    /**
     *  An abstract method that validates the options 
     *  on the specification in the xml properties file
     *  This method verifies for the correctness of number of 
     *  operands and if all the required options are supplied by the client.
     *  @return boolean returns true if success else returns false
     */
    public boolean validateOptions() throws CommandValidationException
    {
        return super.validateOptions();
    }


    /**
     * this method returns the componet_name operand
     * @return component_name
     */
    private String getComponentName()
    {
        return (String) getOperands().get(0);
    }


    /**
     *  creates the DeployProperties which is used as a parameter to the
     *  deploy operation.
     */
    private Map createDeploymentProperties()
    {
        Properties props = new Properties();
        final String cascadeOption   = getOption(CASCADE_OPTION);
        final String dropTablesOption = getOption(DROPTABLES_OPTION);
        final String target = getOption(TARGET_OPTION);                
                
        if (props != null) 
            props.put(DeploymentProperties.TARGET, target);        

     	props.put(DeploymentProperties.NAME, getComponentName() );

        if (cascadeOption != null)
            props.put(DeploymentProperties.CASCADE, cascadeOption);
        if (dropTablesOption != null)
            props.put(Constants.CMP_DROP_TABLES, dropTablesOption);
        return props;
    }


}
