/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/util/stringifier/ModelMBeanInfoStringifier.java,v 1.3 2005/12/25 03:46:07 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:46:07 $
 */
 
package com.sun.cli.util.stringifier;

import java.lang.reflect.Array;
import javax.management.*;

public class ModelMBeanInfoStringifier extends MBeanInfoStringifier implements Stringifier
{
	public static ModelMBeanInfoStringifier	DEFAULT	= new ModelMBeanInfoStringifier(  );
	
		public
	ModelMBeanInfoStringifier(  )
	{
		super(  );
	}
	
		public
	ModelMBeanInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		super( options );
	}
	
		private String
	stringifyArray( Object [] a, Stringifier stringifier)
	{
		String	temp	= "";
		
		if ( Array.getLength( a ) != 0 )
		{
			temp	= "\n" + ArrayStringifier.stringify( a, "\n", stringifier);
		}
		return( temp );
	}
	
		
	// subclass may override
		MBeanAttributeInfoStringifier
	getMBeanAttributeInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		return( new ModelMBeanAttributeInfoStringifier(options) );
	}
	
	// subclass may override
		MBeanOperationInfoStringifier
	getMBeanOperationInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		return( new ModelMBeanOperationInfoStringifier(options) );
	}
	
	// subclass may override
		MBeanConstructorInfoStringifier
	getMBeanConstructorInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		return( new ModelMBeanConstructorInfoStringifier(options) );
	}
	
	// subclass may override
		MBeanNotificationInfoStringifier
	getMBeanNotificationInfoStringifier( MBeanFeatureInfoStringifierOptions options )
	{
		return( new ModelMBeanNotificationInfoStringifier(options) );
	}
}





