/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/spi/JMXMPDefaultConnectorProvider.java,v 1.3 2005/12/25 03:45:42 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:42 $
 */
 
package com.sun.cli.jmx.spi;

import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.JMXConnectorFactory;

public final class JMXMPDefaultConnectorProvider
	implements JMXConnectorProvider
{
		public
	JMXMPDefaultConnectorProvider()
	{
	}
	
	static class Info implements JMXConnectorProviderInfo
	{
		private static final String	DESCRIPTION	=
			"Implements the standard JSR 160 connector.";
		private static final String	USAGE	=
			"connect --host <host> --port port --protocol jmxmp " +
			"[--user <user> --password <pass>]  [connection-name]";
		
			public String
		getDescription()
		{
			return( DESCRIPTION );
		}
			public String
		getUsage()
		{
			return( USAGE );
		}
	}
	
		public static JMXConnectorProviderInfo
	getInfo()
	{
		return( new Info() );
	}
		
	
		public JMXConnector
	connect( java.util.Map m )
		throws java.io.IOException
	{
		final String	host	= (String)m.get( HOST );
		final String	port	= (String)m.get( PORT );
		
		final String	urlString	= "service:jmx:jmxmp://" + host + ":" + port;
		final JMXServiceURL	url	= new JMXServiceURL( urlString );
		
		final JMXConnector	conn	= JMXConnectorFactory.connect( url );
		
		return( conn );
	}
	
	public final static String	MY_PROTOCOL	= "jmxmp";
	
		public boolean
	isSupported( java.util.Map m )
	{
		boolean 	supports	= false;
		
		final String	protocol	= (String)m.get( PROTOCOL );
		if ( MY_PROTOCOL.equals( protocol ) )
		{
			supports	= m.get( HOST ) != null && m.get( PORT ) != null;
		}
		return( supports );
	}
}




