/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin-cli/cli-api/src/java/com/sun/cli/jmx/cmd/InvokeCmd.java,v 1.3 2005/12/25 03:45:37 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:45:37 $
 */
 
package com.sun.cli.jmx.cmd;


import com.sun.cli.jmx.support.ResultsForGetSet;
import com.sun.cli.jmx.support.CLISupportMBeanProxy;
import com.sun.cli.jmx.support.InvokeResult;
import com.sun.cli.util.stringifier.*;

public class InvokeCmd extends JMXCmd
{
		public
	InvokeCmd( final CmdEnv env )
	{
		super( env );
	}
	
		int
	getNumRequiredOperands()
	{
		// require 1, by default
		return( 0 );
	}
	
		public String
	getUsage()
	{
		return( CmdStrings.INVOKE_HELP.toString() );
	}
	
	public static String	FORMAL_NAME	= "invoke";
	
		public static String []
	getNames( )
	{
		return( new String [] { FORMAL_NAME, CmdFactory.DEFAULT_CMD_NAME} );
	}
	
	/*
		Allow two forms of invocation:
		doIt:[args] [targets]
		alias.doIt:[args] 
	 */
		void
	executeInternal()
		throws Exception
	{
		final String	cmdString	= getCmdNameAsInvoked();
		String [] 		targets		= getTargets();
		
		final int		colonPos	= cmdString.indexOf( ":" );
		
		if ( cmdString.equals( FORMAL_NAME ) )
		{
			printUsage();
			return;
		}
		else if ( colonPos < 0  )
		{
			printError( CmdStrings.NO_SUCH_COMMAND + cmdString );
			return;
		}
		
		
		String	argList		= null;
		String methodName	= null;
		final int	dotIndex	= cmdString.indexOf( '.' );
		if ( dotIndex > 0 && dotIndex < colonPos )
		{
			requireNumOperands( 0 );
			targets		= new String [] { cmdString.substring( 0, dotIndex ) };
			methodName	= cmdString.substring( dotIndex + 1, colonPos );
		}
		else
		{
			
			methodName		= cmdString.substring( 0, colonPos );
		}
		
		if ( colonPos + 1 != cmdString.length() )
		{
			argList	= cmdString.substring( colonPos + 1, cmdString.length() );
		}
		else
		{
			argList	= null;
		}
		
		
		//p( "INVOKE: " + methodName + "(" + argList + ") on " + ArrayStringifier.stringify( targets, " " ) );
		
		establishProxy();

		final InvokeResult []	results	= invoke( methodName, argList, targets );
		
		getProxy().mbeanInvoke( methodName, argList, targets );
		
		if ( results.length == 0 )
		{
			println( "Invocation failed: no targets found that match the expression" );
		}
		else
		{
			displayResults( results );
		}
	}
	
		void
	displayResults( final InvokeResult []	results )
	{
		println( new SmartStringifier( "\n", false ).stringify( results ) );
	}
	
		InvokeResult []
	invoke( String operationName, final String argList, final String [] targets )
		throws Exception
	{
		final InvokeResult []	results	= getProxy().mbeanInvoke( operationName, argList, targets );
		
		return( results );
	}
}



