/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.jsfext.component;

import com.sun.enterprise.tools.jsfext.component.ChildManager;
import com.sun.enterprise.tools.jsfext.el.VariableResolver;
import com.sun.enterprise.tools.jsfext.layout.descriptor.ComponentType;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutComponent;
import com.sun.enterprise.tools.jsfext.layout.descriptor.LayoutElement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;

public class ComponentUtil {
    private static Map _types = new HashMap();

    private ComponentUtil() {
    }

    public static UIComponent getChild(UIComponent parent, String id) {
        return ComponentUtil.findChild(parent, id, id);
    }

    public static UIComponent findChild(UIComponent parent, String id, String facetName) {
        if (parent == null) {
            return null;
        }
        UIComponent child2 = null;
        if (facetName != null && (child2 = (UIComponent)parent.getFacets().get(facetName)) != null) {
            return child2;
        }
        if (id != null) {
            for (UIComponent child2 : parent.getChildren()) {
                if (!id.equals(child2.getId())) continue;
                return child2;
            }
        }
        return null;
    }

    public static UIComponent getChild(UIComponent parent, String id, String factoryClass) {
        return ComponentUtil.getChild(parent, id, factoryClass, id);
    }

    public static UIComponent getChild(UIComponent parent, String id, String factoryClass, String facetName) {
        return ComponentUtil.getChild(parent, id, ComponentUtil.getComponentType(factoryClass), null, facetName);
    }

    public static UIComponent getChild(UIComponent parent, String id, String factoryClass, Properties properties) {
        return ComponentUtil.getChild(parent, id, factoryClass, properties, id);
    }

    public static UIComponent getChild(UIComponent parent, String id, String factoryClass, Properties properties, String facetName) {
        return ComponentUtil.getChild(parent, id, ComponentUtil.getComponentType(factoryClass), properties, facetName);
    }

    private static UIComponent getChild(UIComponent parent, String id, ComponentType type, Properties properties, String facetName) {
        LayoutComponent desc = new LayoutComponent(null, id, type);
        if (properties != null) {
            desc.setOptions(properties);
        }
        if (facetName != null) {
            desc.addOption("_facetName", facetName);
        }
        return ComponentUtil.getChild(parent, desc);
    }

    private static ComponentType getComponentType(String factoryClass) {
        ComponentType type = (ComponentType)_types.get(factoryClass);
        if (type == null) {
            type = new ComponentType(factoryClass, factoryClass);
            HashMap<String, ComponentType> newMap = new HashMap<String, ComponentType>(_types);
            newMap.put(factoryClass, type);
            _types = newMap;
        }
        return type;
    }

    public static UIComponent getChild(UIComponent parent, LayoutComponent descriptor) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (parent instanceof ChildManager) {
            return ((ChildManager)parent).getChild(context, descriptor);
        }
        String childId = descriptor.getId(context, parent);
        UIComponent childComponent = ComponentUtil.findChild(parent, childId, (String)descriptor.getEvaluatedOption(context, "_facetName", null));
        if (childComponent != null) {
            return childComponent;
        }
        return ComponentUtil.createChildComponent(context, descriptor, parent);
    }

    public static UIComponent createChildComponent(FacesContext context, LayoutComponent descriptor, UIComponent parent) {
        if (descriptor == null) {
            throw new IllegalArgumentException("'descriptor' cannot be null!");
        }
        return descriptor.getType().getFactory().create(context, descriptor, parent);
    }

    public static Object setOption(FacesContext context, String key, Object value, LayoutElement desc, UIComponent component) {
        if ((value = VariableResolver.resolveVariables(context, desc, component, value)) == null) {
            return null;
        }
        String strVal = value.toString();
        if (UIComponentTag.isValueReference((String)strVal)) {
            ValueBinding vb = context.getApplication().createValueBinding(strVal);
            if (component != null) {
                component.setValueBinding(key, vb);
            }
            value = vb;
        } else if (component != null) {
            component.getAttributes().put(key, value);
        }
        return value;
    }

    public static Object resolveValue(FacesContext context, LayoutElement elt, UIComponent parent, String value) {
        String strVal;
        Object result = VariableResolver.resolveVariables(context, elt, parent, value);
        if (result != null && UIComponentTag.isValueReference((String)(strVal = result.toString()))) {
            ValueBinding vb = context.getApplication().createValueBinding(strVal);
            result = vb.getValue(context);
        }
        return result;
    }
}

