/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.tree;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.ViewBeanManager;
import com.iplanet.jato.view.TreeViewStateData;
import com.iplanet.jato.view.ViewBean;
import com.sun.enterprise.tools.admingui.tree.IndexTreeModel;
import com.sun.enterprise.tools.admingui.tree.TreeReader;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorViewBeanBase;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IndexTreeNode
implements Serializable {
    private static HashMap idsMap = new HashMap();
    private static int nodeCount = 3;
    public static final String INSTANCE_NAME = "instanceName";
    public static final String CONFIG_NAME = "configName";
    public static final String CLUSTER_NAME = "clusterName";
    public static final String NODEAGENT_NAME = "nodeAgentName";
    public static final String EDIT_KEY_VALUE = "editKeyValue";
    public static final String OBJECT_NAME = "objectName";
    public static final String APPLICATION_TYPE = "ApplicationType";
    private int id = 0;
    private IndexTreeNode parent;
    private String name;
    private String type;
    private String hid;
    private String icon = null;
    private String iconExpanded = null;
    private String link = "underConstruction";
    protected Element dynamicChild = null;
    protected List children = new ArrayList();
    private Map attributes = new HashMap();
    protected IndexTreeModel model;
    protected boolean isExpanded = false;

    private static String computeID(IndexTreeNode parent, IndexTreeNode child, String name) {
        String key = child.getNamePath();
        String id = (String)idsMap.get(key);
        if (id == null) {
            id = "" + ++nodeCount;
            idsMap.put(key, id);
        }
        return id;
    }

    private String qualifyType(String type) {
        if (type.equalsIgnoreCase("container")) {
            return "container";
        }
        if (type.equalsIgnoreCase("leaf")) {
            return "leaf";
        }
        if (type.equalsIgnoreCase("root")) {
            return "root";
        }
        throw new RuntimeException("Unknown node type specified. Error likely in treeXML.");
    }

    private String qualifyName(String name) {
        if (name != null && name.length() > 0) {
            return name;
        }
        throw new RuntimeException("Node name must be non-null and non-blank. Error likely in treeXML.");
    }

    public IndexTreeNode(IndexTreeNode parent, String type, String name, IndexTreeModel model) {
        this.type = this.qualifyType(type);
        this.name = this.qualifyName(name);
        this.id = model.getNextNodeID();
        this.model = model;
        this.link = "underConstruction";
        this.setParent(parent);
        this.setAttribute("name", name);
        this.setAttribute("id", this.getPath());
        this.setRefresh(true);
    }

    public void setParent(IndexTreeNode parent) {
        if (parent == null) {
            parent = this.model.getRoot();
        }
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
            if (parent.getType().equals("leaf")) {
                parent.type = "container";
            }
        }
        this.hid = IndexTreeNode.computeID(parent, this, this.name);
    }

    public void removeChild(String childName) {
        for (IndexTreeNode childNode : this.children) {
            IndexTreeNode n;
            if (!childNode.getName().equals(childName) || (n = childNode.getParent()) == null) continue;
            n.children.remove(childNode);
            break;
        }
    }

    public IndexTreeNode getChild(String childName) {
        for (IndexTreeNode childNode : this.children) {
            if (!childNode.getName().equals(childName)) continue;
            return childNode;
        }
        return null;
    }

    public IndexTreeNode getChildByUniqueID(String uniqueID) {
        for (IndexTreeNode childNode : this.children) {
            if (childNode.getUniqueID() == null || !childNode.getUniqueID().equals(uniqueID)) continue;
            return childNode;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addChild(IndexTreeNode child) {
        String isCluster = null;
        if (child.getName().equalsIgnoreCase("Group Management Service")) {
            ObjectName[] targets = null;
            try {
                targets = (ObjectName[])MBeanUtil.invoke("com.sun.appserv:type=config,name=" + child.getParent().getName() + ",category=config", "listReferencees", null, null);
                if (targets != null) {
                    for (int j = 0; j < targets.length; ++j) {
                        String objectType = targets[j].getKeyProperty("type");
                        isCluster = objectType.equalsIgnoreCase("cluster") ? "true" : "false";
                    }
                }
                if (!isCluster.equals("true")) return;
                this.children.add(child);
                return;
            }
            catch (Exception ex) {
                return;
            }
        } else {
            this.children.add(child);
        }
    }

    public void setDynamicChild(Element node) {
        this.dynamicChild = node;
    }

    protected void loadParams(Element node, HashMap params) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeName = child.getNodeName();
            if (!nodeName.equalsIgnoreCase("parameter")) continue;
            String name = ((Element)child).getAttribute("name");
            String value = ((Element)child).getAttribute("value");
            if (name == null || value == null) continue;
            value = this.replaceTokens(value);
            params.put(name, value);
        }
    }

    protected IndexTreeNode createNode(Element element, String name, Object objectName) {
        boolean hasChildren;
        if (this.getChild(name) != null) {
            return null;
        }
        IndexTreeNode treeNode = IndexTreeNode.createNode(element, this, "leaf", name, this.model);
        if (MBeanUtil.isValidMBean(objectName.toString())) {
            treeNode.setAttribute(OBJECT_NAME, objectName.toString());
        }
        if (hasChildren = TreeReader.process(element, this.model, treeNode)) {
            treeNode.type = "container";
            treeNode.getChildren();
        }
        return treeNode;
    }

    public static IndexTreeNode createNode(Element element, IndexTreeNode parent, String nodeType, String name, IndexTreeModel model) {
        IndexTreeNode treeNode = null;
        String classType = element.getAttribute("classType");
        if (classType == null || classType.length() == 0) {
            treeNode = new IndexTreeNode(parent, nodeType, name, model);
        } else {
            String clazz = TreeReader.getClass(classType);
            if (clazz == null) {
                throw new RuntimeException("NodeClassType not specified for: " + classType);
            }
            try {
                Class<?> treeNodeClass = Class.forName(clazz);
                Constructor<?> constructor = treeNodeClass.getConstructor(IndexTreeNode.class, String.class, String.class, IndexTreeModel.class);
                treeNode = (IndexTreeNode)constructor.newInstance(parent, nodeType, name, model);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        treeNode.setIcon(element.getAttribute("icon"));
        treeNode.setIconExpanded(element.getAttribute("expandIcon"));
        treeNode.setLink(element.getAttribute("link"));
        String id = element.getAttribute("id");
        if (id != null && id.length() > 0) {
            treeNode.setUniqueID(id);
        }
        if (nodeType.equalsIgnoreCase("root")) {
            model.setRoot(treeNode);
        }
        IndexTreeNode.processAttributes(element, treeNode);
        return treeNode;
    }

    private static void processAttributes(Element node, IndexTreeNode treeNode) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeName = child.getNodeName();
            if (!nodeName.equalsIgnoreCase("attribute")) continue;
            String name = ((Element)child).getAttribute("name");
            String value = ((Element)child).getAttribute("value");
            if (value == null || value.length() == 0) {
                ArrayList<String> values = new ArrayList<String>();
                for (Node n = child.getFirstChild(); n != null; n = n.getNextSibling()) {
                    String v;
                    if (!n.getNodeName().equalsIgnoreCase("values") || (v = ((Element)n).getAttribute("value")) == null || v.length() <= 0) continue;
                    v = treeNode.replaceTokens(v);
                    values.add(v);
                }
                if (values.size() <= 0) continue;
                treeNode.setAttribute(name, values);
                continue;
            }
            if (name == null || name.length() <= 0 || value == null || value.length() <= 0) continue;
            value = treeNode.replaceTokens(value);
            treeNode.setAttribute(name, value);
        }
    }

    protected String replaceTokens(String str) {
        if (str == null) {
            return str;
        }
        return this.replaceVariableWithAttribute(str, "$", "(", ")", "");
    }

    public String replaceVariableWithAttribute(String string, String startToken, String typeDelim, String endToken, String valueForNull) {
        int startIndex = string.lastIndexOf(startToken);
        int startTokenLen = startToken.length();
        int delimLen = typeDelim.length();
        int endTokenLen = endToken.length();
        boolean expressionIsWholeString = false;
        while (startIndex != -1) {
            int endIndex;
            int delimIndex;
            if (startIndex == 0 && string.endsWith(endToken)) {
                expressionIsWholeString = true;
            }
            if ((delimIndex = string.indexOf(typeDelim, startIndex + startTokenLen)) != -1 && (endIndex = string.indexOf(endToken, delimIndex + delimLen)) != -1) {
                if (startIndex + startTokenLen != delimIndex) {
                    throw new RuntimeException("types not support in tree expressions.");
                }
                String variable = string.substring(delimIndex + delimLen, endIndex);
                Object value = this.getAttribute(variable);
                variable = value == null ? valueForNull : (!(value instanceof String) ? value.toString() : (String)value);
                if (expressionIsWholeString) {
                    return variable;
                }
                string = string.substring(0, startIndex) + variable + string.substring(endIndex + endTokenLen);
            }
            startIndex = string.lastIndexOf(startToken);
        }
        return string;
    }

    protected void removeDeletedNodes(HashSet newNames) {
        if (newNames.size() != this.children.size()) {
            boolean doAgain = true;
            block0: while (doAgain) {
                doAgain = false;
                for (int i = 0; i < this.children.size(); ++i) {
                    if (newNames.contains(((IndexTreeNode)this.children.get((int)i)).name)) continue;
                    this.children.remove(i);
                    doAgain = true;
                    continue block0;
                }
            }
        }
        if (this.children.size() == 0) {
            this.closeNode(RequestManager.getRequestContext());
        }
    }

    protected boolean isChildValid(ObjectName objectName) {
        try {
            String type;
            String category = objectName.getKeyProperty("category");
            if (category.equalsIgnoreCase("monitor")) {
                return true;
            }
            String objectType = objectName.getKeyProperty("type");
            if ((objectType.equals("j2ee-application") || objectType.equals("web-module") || objectType.equals("ejb-module") || objectType.equals("connector-module")) && !(type = (String)MBeanUtil.getAttribute(objectName, "object_type")).equalsIgnoreCase("user")) {
                return false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected void ensureChildren() {
    }

    public List getChildren() {
        this.ensureChildren();
        return this.children;
    }

    public String toString() {
        return "[name=" + this.getNamePath() + " path=" + this.getPath() + " hid=" + this.getHighlightID() + "]";
    }

    public String getNamePath() {
        if (this.parent != null) {
            return this.parent.getNamePath() + "." + this.name;
        }
        return "" + this.name;
    }

    public String getPath() {
        if (this.parent != null) {
            return this.parent.getPath() + "." + this.id;
        }
        return "" + this.id;
    }

    public IndexTreeNode getNextSibling() {
        IndexTreeNode result = null;
        if (this.parent != null) {
            int index = this.parent.getChildren().indexOf(this);
            if (++index < this.parent.getChildren().size()) {
                result = (IndexTreeNode)this.parent.getChildren().get(index);
            }
        }
        return result;
    }

    public void setIsExpanded(boolean expanded) {
        if (this.isExpanded && !expanded) {
            this.setRefresh(true);
        }
        this.isExpanded = expanded;
    }

    public IndexTreeNode getParent() {
        return this.parent;
    }

    public String getHighlightID() {
        return this.hid;
    }

    public String getHighlightIDPath() {
        String path = this.hid;
        IndexTreeNode p = this.parent;
        while (p != null) {
            path = path + "." + p.getHighlightID();
            p = p.parent;
        }
        return path;
    }

    public String getName() {
        return Util.getMessage(this.name);
    }

    public String getType() {
        return this.type;
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, true);
    }

    public Object getAttribute(String name, boolean lookUpHiearchy) {
        Object obj = this.getAttributes().get(name);
        if (lookUpHiearchy && obj == null && this.parent != null) {
            return this.parent.getAttribute(name);
        }
        return obj;
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void setRefresh(boolean refresh) {
        this.setAttribute("refresh", new Boolean(refresh));
    }

    public boolean getRefresh() {
        return (Boolean)this.getAttributes().get("refresh");
    }

    public void setUniqueID(String uniqueID) {
        this.setAttribute("UniqueID", uniqueID);
    }

    public String getUniqueID() {
        return (String)this.getAttributes().get("UniqueID");
    }

    public String getDisplayName() {
        String displayName = (String)this.getAttributes().get("displayName");
        return displayName == null ? this.getName() : displayName;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void removeAllChildren() {
        this.children.clear();
    }

    protected Map getAttributes() {
        return this.attributes;
    }

    public String getIconName(boolean expanded) {
        if (expanded && this.iconExpanded != null && !this.iconExpanded.equals("")) {
            return this.iconExpanded;
        }
        if (this.icon != null) {
            return this.icon;
        }
        return "object.gif";
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setIconExpanded(String iconExpanded) {
        this.iconExpanded = iconExpanded;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getID() {
        return this.id;
    }

    public IndexTreeModel getModel() {
        return this.model;
    }

    public boolean closeNode(RequestContext rc) {
        boolean closed = false;
        TreeViewStateData data = (TreeViewStateData)rc.getRequest().getSession().getAttribute(this.model.getStateDataName());
        if (data == null) {
            return closed;
        }
        if (data.isNodeExpanded(this.getPath())) {
            closed = true;
            data.setNodeExpanded(this.getPath(), false);
        }
        return closed;
    }

    public boolean openNode(RequestContext rc) {
        boolean opened = false;
        TreeViewStateData data = (TreeViewStateData)rc.getRequest().getSession().getAttribute(this.model.getStateDataName());
        if (data == null) {
            return opened;
        }
        for (IndexTreeNode node = this; node != null && node.getParent() != null; node = node.getParent()) {
            if (data.isNodeExpanded(node.getPath())) continue;
            opened = true;
            data.setNodeExpanded(node.getPath(), true);
        }
        return opened;
    }

    private void setRequestAttribute(HttpServletRequest req, String attrName) {
        String attr = (String)this.getAttribute(attrName);
        if (attr == null) {
            req.removeAttribute(attrName);
        } else {
            req.setAttribute(attrName, (Object)attr);
        }
    }

    private void setRequestAttributes(HttpServletRequest req) {
        req.setAttribute(EDIT_KEY_VALUE, (Object)this.name);
        req.setAttribute(OBJECT_NAME, this.getAttribute(OBJECT_NAME, false));
        req.getSession().setAttribute(EDIT_KEY_VALUE, (Object)this.name);
        req.setAttribute("numberOfChildNodes", (Object)new Integer(this.getChildren().size()));
        this.setRequestAttribute(req, INSTANCE_NAME);
        this.setRequestAttribute(req, CONFIG_NAME);
        this.setRequestAttribute(req, CLUSTER_NAME);
        this.setRequestAttribute(req, NODEAGENT_NAME);
        this.setRequestAttribute(req, APPLICATION_TYPE);
    }

    public static IndexTreeNode validateNode(RequestContext rc, IndexTreeNode node) {
        String objectName = (String)node.getAttribute(OBJECT_NAME, false);
        if (objectName == null) {
            return node;
        }
        boolean valid = MBeanUtil.isValidMBean(objectName);
        if (valid) {
            return node;
        }
        IndexTreeNode parent = node.getParent();
        parent.setRefresh(true);
        rc.getRequest().setAttribute("refreshTree", (Object)new Boolean("true"));
        return IndexTreeNode.validateNode(rc, parent);
    }

    public void handleSelection(RequestContext rc) throws ClassNotFoundException, ServletException, IOException {
        if (Util.isLoggableFINER()) {
            Util.logFINER("ENTERING IndexTreeNode.handleSelection('" + this.name + "')");
        }
        IndexTreeNode selectedNode = IndexTreeNode.validateNode(rc, this);
        this.model.setCurrentNode(selectedNode);
        Util.setSelectedNode(selectedNode);
        selectedNode.setRequestAttributes(rc.getRequest());
        String linkPage = selectedNode.getLink();
        if (linkPage != null) {
            if (linkPage.toLowerCase().endsWith(".html") || linkPage.toLowerCase().endsWith(".jsp")) {
                rc.getServletContext().getRequestDispatcher(Util.getLocalizedURL(rc, linkPage)).forward((ServletRequest)rc.getRequest(), (ServletResponse)rc.getResponse());
            } else {
                ViewBeanManager mgr = rc.getViewBeanManager();
                ViewBean targetView = mgr.getViewBean(linkPage);
                if (targetView instanceof DescriptorViewBeanBase) {
                    DescriptorViewBeanBase viewBean = (DescriptorViewBeanBase)targetView;
                    viewBean.setAttributes(this.getAttributes());
                }
                targetView.forwardTo(rc);
            }
        } else {
            throw new FrameworkException("The link in the Tree node must not be null!");
        }
        if (Util.isLoggableFINER()) {
            Util.logFINER("LEAVING IndexTreeNode.handleSelection('" + this.name + "')");
        }
    }
}

