/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat5;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import com.sun.org.apache.commons.modeler.Registry;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.naming.Context;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.res.StringManager;

public class MapperListener
implements NotificationListener,
NotificationFilter {
    private static Log log = LogFactory.getLog(MapperListener.class);
    protected Mapper mapper = null;
    protected MBeanServer mBeanServer = null;
    private StringManager sm = StringManager.getManager("org.apache.coyote.tomcat5");
    private String domain = "*";
    private String engine = "*";
    private int port;
    private String defaultHost;
    private String myInstance;

    public MapperListener(Mapper mapper) {
        this.mapper = mapper;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
    }

    public void init() {
        this.myInstance = System.getProperty("com.sun.aas.instanceName");
        try {
            this.mBeanServer = Registry.getServer();
            this.registerEngine();
            String onStr = this.domain + ":type=Host,*";
            ObjectName objectName = new ObjectName(onStr);
            Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.registerHost(oi.getObjectName());
            }
            onStr = "*:j2eeType=WebModule,*";
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.registerContext(oi.getObjectName());
            }
            onStr = "*:j2eeType=Servlet,*";
            objectName = new ObjectName(onStr);
            set = this.mBeanServer.queryMBeans(objectName, null);
            for (ObjectInstance oi : set) {
                this.registerWrapper(oi.getObjectName());
            }
            onStr = "JMImplementation:type=MBeanServerDelegate";
            objectName = new ObjectName(onStr);
            this.mBeanServer.addNotificationListener(objectName, this, (NotificationFilter)this, null);
        }
        catch (Exception e) {
            log.warn("Error registering contexts", e);
        }
    }

    public boolean isNotificationEnabled(Notification notification) {
        if (notification instanceof MBeanServerNotification) {
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            String otherInstance = objectName.getKeyProperty("J2EEServer");
            if (this.myInstance != null && otherInstance != null && !otherInstance.equals(this.myInstance)) {
                return false;
            }
        }
        return true;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            String type;
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            String j2eeType = objectName.getKeyProperty("j2eeType");
            String engineName = null;
            if (j2eeType != null && (j2eeType.equals("WebModule") || j2eeType.equals("Servlet")) && this.mBeanServer.isRegistered(objectName)) {
                MBeanInfo info = null;
                try {
                    info = this.mBeanServer.getMBeanInfo(objectName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (info != null) {
                    boolean hasEngineNameAttribute = false;
                    MBeanAttributeInfo[] attrInfo = info.getAttributes();
                    if (attrInfo != null) {
                        for (int i = 0; i < attrInfo.length; ++i) {
                            if (!"engineName".equals(attrInfo[i].getName())) continue;
                            hasEngineNameAttribute = true;
                            break;
                        }
                    }
                    if (hasEngineNameAttribute) {
                        try {
                            engineName = (String)this.mBeanServer.getAttribute(objectName, "engineName");
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            if (!("*".equals(this.domain) || this.domain.equals(objectName.getDomain()) || this.domain.equals(engineName) || engineName == null)) {
                return;
            }
            log.debug("Handle " + objectName);
            if (notification.getType().equals("JMX.mbean.registered")) {
                type = objectName.getKeyProperty("type");
                if ("Host".equals(type)) {
                    try {
                        this.registerHost(objectName);
                    }
                    catch (Exception e) {
                        log.warn("Error registering Host " + objectName, e);
                    }
                }
                if (j2eeType != null) {
                    if (j2eeType.equals("WebModule")) {
                        try {
                            this.registerContext(objectName);
                        }
                        catch (Throwable t) {
                            log.warn("Error registering Context " + objectName, t);
                        }
                    } else if (j2eeType.equals("Servlet")) {
                        try {
                            this.registerWrapper(objectName);
                        }
                        catch (Throwable t) {
                            log.warn("Error registering Wrapper " + objectName, t);
                        }
                    }
                }
            } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                type = objectName.getKeyProperty("type");
                if ("Host".equals(type)) {
                    try {
                        this.unregisterHost(objectName);
                    }
                    catch (Exception e) {
                        log.warn("Error unregistering Host " + objectName, e);
                    }
                }
                if (j2eeType != null && j2eeType.equals("WebModule")) {
                    try {
                        this.unregisterContext(objectName);
                    }
                    catch (Throwable t) {
                        log.warn("Error unregistering webapp " + objectName, t);
                    }
                }
            }
        }
    }

    private void registerEngine() throws Exception {
        ObjectName hostName;
        ObjectName engineName = new ObjectName(this.domain + ":type=Engine");
        if (!this.mBeanServer.isRegistered(engineName)) {
            return;
        }
        if (this.defaultHost == null) {
            this.defaultHost = (String)this.mBeanServer.getAttribute(engineName, "defaultHost");
        }
        if (!this.mBeanServer.isRegistered(hostName = new ObjectName(this.domain + ":type=Host," + "host=" + this.defaultHost))) {
            String onStr = this.domain + ":type=Host,*";
            ObjectName objectName = new ObjectName(onStr);
            Set<ObjectInstance> set = this.mBeanServer.queryMBeans(objectName, null);
            Iterator<ObjectInstance> iterator = set.iterator();
            boolean isRegisteredWithAlias = false;
            block0: while (iterator.hasNext() && !isRegisteredWithAlias) {
                ObjectInstance oi = iterator.next();
                hostName = oi.getObjectName();
                String[] aliases = (String[])this.mBeanServer.invoke(hostName, "findAliases", null, null);
                for (int i = 0; i < aliases.length; ++i) {
                    if (!aliases[i].equalsIgnoreCase(this.defaultHost)) continue;
                    isRegisteredWithAlias = true;
                    continue block0;
                }
            }
            if (!isRegisteredWithAlias) {
                log.warn("Unknown default host: " + this.defaultHost);
            }
        }
        if (this.defaultHost != null) {
            this.mapper.setDefaultHostName(this.defaultHost);
        }
    }

    private void registerHost(ObjectName objectName) throws Exception {
        String name = objectName.getKeyProperty("host");
        if (name != null) {
            int[] ports = (int[])this.mBeanServer.invoke(objectName, "findPorts", null, null);
            boolean portMatch = false;
            if (ports != null) {
                for (int i = 0; i < ports.length; ++i) {
                    if (ports[i] != this.port) continue;
                    portMatch = true;
                    break;
                }
            }
            if (!portMatch) {
                return;
            }
            String[] aliases = (String[])this.mBeanServer.invoke(objectName, "findAliases", null, null);
            this.mapper.addHost(name, aliases, objectName);
        }
    }

    private void unregisterHost(ObjectName objectName) throws Exception {
        String name = objectName.getKeyProperty("host");
        if (name != null) {
            int[] ports = (int[])this.mBeanServer.invoke(objectName, "findPorts", null, null);
            boolean portMatch = false;
            if (ports != null) {
                for (int i = 0; i < ports.length; ++i) {
                    if (ports[i] != this.port) continue;
                    portMatch = true;
                    break;
                }
            }
            if (!portMatch) {
                return;
            }
        }
        this.mapper.removeHost(name);
    }

    private void registerContext(ObjectName objectName) throws Exception {
        int slash;
        String name = objectName.getKeyProperty("name");
        String targetDomain = objectName.getDomain();
        if (!this.domain.equals(targetDomain)) {
            try {
                targetDomain = (String)this.mBeanServer.getAttribute(objectName, "engineName");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.domain.equals(targetDomain)) {
                return;
            }
        }
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        if (contextName.equals("/")) {
            contextName = "";
        }
        log.debug(this.sm.getString("mapperListener.registerContext", contextName));
        Object context = this.mBeanServer.invoke(objectName, "findMappingObject", null, null);
        Context resources = (Context)this.mBeanServer.invoke(objectName, "findStaticResources", null, null);
        String[] welcomeFiles = (String[])this.mBeanServer.getAttribute(objectName, "welcomeFiles");
        this.mapper.addContext(hostName, contextName, context, welcomeFiles, resources);
    }

    private void unregisterContext(ObjectName objectName) throws Exception {
        int slash;
        String name = objectName.getKeyProperty("name");
        String targetDomain = objectName.getDomain();
        if (!this.domain.equals(targetDomain)) {
            try {
                targetDomain = (String)this.mBeanServer.getAttribute(objectName, "engineName");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.domain.equals(targetDomain)) {
                return;
            }
        }
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        if (contextName.equals("/")) {
            contextName = "";
        }
        log.debug(this.sm.getString("mapperListener.unregisterContext", contextName));
        this.mapper.removeContext(hostName, contextName);
    }

    private void registerWrapper(ObjectName objectName) throws Exception {
        int slash;
        String targetDomain = objectName.getDomain();
        if (!this.domain.equals(targetDomain)) {
            try {
                targetDomain = (String)this.mBeanServer.getAttribute(objectName, "engineName");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.domain.equals(targetDomain)) {
                return;
            }
        }
        String wrapperName = objectName.getKeyProperty("name");
        String name = objectName.getKeyProperty("WebModule");
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        if (contextName.equals("/")) {
            contextName = "";
        }
        log.debug(this.sm.getString("mapperListener.registerWrapper", wrapperName, contextName));
        String[] mappings = (String[])this.mBeanServer.invoke(objectName, "findMappings", null, null);
        Object wrapper = this.mBeanServer.invoke(objectName, "findMappingObject", null, null);
        for (int i = 0; i < mappings.length; ++i) {
            boolean jspWildCard = wrapperName.equals("jsp") && mappings[i].endsWith("/*");
            this.mapper.addWrapper(hostName, contextName, mappings[i], wrapper, jspWildCard);
        }
    }
}

