/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.StringTokenizer;
import javax.management.MBeanException;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.DefaultContext;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.ServerFactory;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.mbeans.MBeanFactory;
import org.apache.catalina.mbeans.MBeanUtils;

public class ServerLifecycleListener
implements ContainerListener,
LifecycleListener,
PropertyChangeListener {
    private static Log log = LogFactory.getLog(ServerLifecycleListener.class);
    protected int debug = 0;
    protected String descriptors = null;
    protected String adaptor = null;
    protected String adaptorHost = null;
    protected int adaptorPort = -1;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(String descriptors) {
        this.descriptors = descriptors;
    }

    public String getAdaptor() {
        return this.adaptor;
    }

    public void setAdaptor(String adaptor) {
        this.adaptor = adaptor;
    }

    public String getAdaptorHost() {
        return this.adaptorHost;
    }

    public void setAdaptorHost(String adaptorHost) {
        this.adaptorHost = adaptorHost;
    }

    public int getAdaptorPort() {
        return this.adaptorPort;
    }

    public void setAdaptorPort(int adaptorPort) {
        this.adaptorPort = adaptorPort;
    }

    public void containerEvent(ContainerEvent event) {
        try {
            String type = event.getType();
            if ("addChild".equals(type)) {
                this.processContainerAddChild(event.getContainer(), (Container)event.getData());
            } else if ("removeChild".equals(type)) {
                this.processContainerRemoveChild(event.getContainer(), (Container)event.getData());
            }
        }
        catch (Exception e) {
            log.error("Exception processing event " + event, e);
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        StandardContext context;
        Lifecycle lifecycle = event.getLifecycle();
        if ("start".equals(event.getType())) {
            if (lifecycle instanceof Server) {
                this.loadMBeanDescriptors();
                this.createMBeans();
                if (this.adaptor != null) {
                    try {
                        MBeanUtils.createRMIAdaptor(this.adaptor, this.adaptorHost, this.adaptorPort);
                    }
                    catch (Exception e) {
                        log.error("createAdaptor: Exception", e);
                    }
                }
            }
            if (lifecycle instanceof Service) {
                try {
                    MBeanFactory factory = new MBeanFactory();
                    this.createMBeans(factory);
                    this.loadMBeanDescriptors();
                    this.createMBeans((Service)((Object)lifecycle));
                }
                catch (Exception ex) {
                    log.error("Create mbean factory");
                }
            }
        } else if ("stop".equals(event.getType())) {
            try {
                if (lifecycle instanceof Server) {
                    this.destroyMBeans((Server)((Object)lifecycle));
                }
                if (lifecycle instanceof Service) {
                    this.destroyMBeans((Service)((Object)lifecycle));
                }
            }
            catch (MBeanException t) {
                Exception e = t.getTargetException();
                if (e == null) {
                    e = t;
                }
                log.error("destroyMBeans: MBeanException", e);
            }
            catch (Throwable t) {
                log.error("destroyMBeans: Throwable", t);
            }
        }
        if (("reload".equals(event.getType()) || "start".equals(event.getType())) && lifecycle instanceof StandardContext && (context = (StandardContext)lifecycle).getPrivileged()) {
            context.getServletContext().setAttribute("org.apache.catalina.Registry", (Object)MBeanUtils.createRegistry());
            context.getServletContext().setAttribute("org.apache.catalina.MBeanServer", (Object)MBeanUtils.createServer());
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof Container) {
            try {
                this.processContainerPropertyChange((Container)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                log.error("Exception handling Container property change", e);
            }
        } else if (event.getSource() instanceof DefaultContext) {
            try {
                this.processDefaultContextPropertyChange((DefaultContext)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                log.error("Exception handling DefaultContext property change", e);
            }
        } else if (event.getSource() instanceof NamingResources) {
            try {
                this.processNamingResourcesPropertyChange((NamingResources)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                log.error("Exception handling NamingResources property change", e);
            }
        } else if (event.getSource() instanceof Server) {
            try {
                this.processServerPropertyChange((Server)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                log.error("Exception handing Server property change", e);
            }
        } else if (event.getSource() instanceof Service) {
            try {
                this.processServicePropertyChange((Service)event.getSource(), event.getPropertyName(), event.getOldValue(), event.getNewValue());
            }
            catch (Exception e) {
                log.error("Exception handing Service property change", e);
            }
        }
    }

    protected void loadMBeanDescriptors() {
        if (this.descriptors != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.descriptors, ";");
            while (tokenizer.hasMoreTokens()) {
                String resource = tokenizer.nextToken();
                MBeanUtils.loadMBeanDescriptors(resource);
            }
        }
    }

    protected void createMBeans() {
        try {
            MBeanFactory factory = new MBeanFactory();
            this.createMBeans(factory);
            this.createMBeans(ServerFactory.getServer());
        }
        catch (MBeanException t) {
            Exception e = t.getTargetException();
            if (e == null) {
                e = t;
            }
            log.error("createMBeans: MBeanException", e);
        }
        catch (Throwable t) {
            log.error("createMBeans: Throwable", t);
        }
    }

    protected void createMBeans(Connector connector) throws Exception {
    }

    protected void createMBeans(Context context) throws Exception {
        Manager cManager;
        Loader cLoader;
        context.addContainerListener(this);
        if (context instanceof StandardContext) {
            ((StandardContext)context).addPropertyChangeListener(this);
            ((StandardContext)context).addLifecycleListener(this);
        }
        if (context.getPrivileged()) {
            context.getServletContext().setAttribute("org.apache.catalina.Registry", (Object)MBeanUtils.createRegistry());
            context.getServletContext().setAttribute("org.apache.catalina.MBeanServer", (Object)MBeanUtils.createServer());
        }
        if ((cLoader = context.getLoader()) != null && log.isDebugEnabled()) {
            log.debug("Creating MBean for Loader " + cLoader);
        }
        Logger hLogger = context.getParent().getLogger();
        Logger cLogger = context.getLogger();
        if (cLogger != null && cLogger != hLogger && log.isDebugEnabled()) {
            log.debug("Creating MBean for Logger " + cLogger);
        }
        if ((cManager = context.getManager()) != null && log.isDebugEnabled()) {
            log.debug("Creating MBean for Manager " + cManager);
        }
        Realm hRealm = context.getParent().getRealm();
        Realm cRealm = context.getRealm();
        if (cRealm != null && cRealm != hRealm && log.isDebugEnabled()) {
            log.debug("Creating MBean for Realm " + cRealm);
        }
        NamingResources resources = context.getNamingResources();
        this.createMBeans(resources);
    }

    protected void createMBeans(ContextEnvironment environment) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Creating MBean for ContextEnvironment " + environment);
        }
        MBeanUtils.createMBean(environment);
    }

    protected void createMBeans(ContextResource resource) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Creating MBean for ContextResource " + resource);
        }
        MBeanUtils.createMBean(resource);
    }

    protected void createMBeans(ContextResourceLink resourceLink) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Creating MBean for ContextResourceLink " + resourceLink);
        }
        MBeanUtils.createMBean(resourceLink);
    }

    protected void createMBeans(DefaultContext dcontext) throws Exception {
        Manager dManager;
        if (log.isDebugEnabled()) {
            log.debug("Creating MBean for DefaultContext " + dcontext);
        }
        MBeanUtils.createMBean(dcontext);
        dcontext.addPropertyChangeListener(this);
        Loader dLoader = dcontext.getLoader();
        if (dLoader != null && log.isDebugEnabled()) {
            log.debug("Creating MBean for Loader " + dLoader);
        }
        if ((dManager = dcontext.getManager()) != null && log.isDebugEnabled()) {
            log.debug("Creating MBean for Manager " + dManager);
        }
        NamingResources resources = dcontext.getNamingResources();
        this.createMBeans(resources);
    }

    protected void createMBeans(Engine engine) throws Exception {
        Realm eRealm;
        Logger eLogger;
        if (log.isDebugEnabled()) {
            log.debug("Creating MBean for Engine " + engine);
        }
        engine.addContainerListener(this);
        if (engine instanceof StandardEngine) {
            ((StandardEngine)engine).addPropertyChangeListener(this);
        }
        if ((eLogger = engine.getLogger()) != null && log.isDebugEnabled()) {
            log.debug("Creating MBean for Logger " + eLogger);
        }
        if ((eRealm = engine.getRealm()) != null && log.isDebugEnabled()) {
            log.debug("Creating MBean for Realm " + eRealm);
        }
        Container[] hosts = engine.findChildren();
        for (int j = 0; j < hosts.length; ++j) {
            this.createMBeans((Host)hosts[j]);
        }
        DefaultContext dcontext = engine.getDefaultContext();
        if (dcontext != null) {
            dcontext.setParent(engine);
            this.createMBeans(dcontext);
        }
    }

    protected void createMBeans(Host host) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Creating MBean for Host " + host);
        }
        host.addContainerListener(this);
        if (host instanceof StandardHost) {
            ((StandardHost)host).addPropertyChangeListener(this);
        }
        Logger eLogger = host.getParent().getLogger();
        Logger hLogger = host.getLogger();
        if (hLogger != null && hLogger != eLogger && log.isDebugEnabled()) {
            log.debug("Creating MBean for Logger " + hLogger);
        }
        Realm eRealm = host.getParent().getRealm();
        Realm hRealm = host.getRealm();
        if (hRealm != null && hRealm != eRealm && log.isDebugEnabled()) {
            log.debug("Creating MBean for Realm " + hRealm);
        }
        Container[] contexts = host.findChildren();
        for (int k = 0; k < contexts.length; ++k) {
            this.createMBeans((Context)contexts[k]);
        }
        DefaultContext dcontext = host.getDefaultContext();
        if (dcontext != null) {
            dcontext.setParent(host);
            this.createMBeans(dcontext);
        }
    }

    protected void createMBeans(MBeanFactory factory) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Creating MBean for MBeanFactory " + factory);
        }
        MBeanUtils.createMBean(factory);
    }

    protected void createMBeans(NamingResources resources) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Creating MBean for NamingResources " + resources);
        }
        MBeanUtils.createMBean(resources);
        resources.addPropertyChangeListener(this);
        ContextEnvironment[] environments = resources.findEnvironments();
        for (int i = 0; i < environments.length; ++i) {
            this.createMBeans(environments[i]);
        }
        ContextResource[] cresources = resources.findResources();
        for (int i = 0; i < cresources.length; ++i) {
            this.createMBeans(cresources[i]);
        }
        ContextResourceLink[] cresourcelinks = resources.findResourceLinks();
        for (int i = 0; i < cresourcelinks.length; ++i) {
            this.createMBeans(cresourcelinks[i]);
        }
    }

    protected void createMBeans(Server server) throws Exception {
        NamingResources resources;
        if (log.isDebugEnabled()) {
            log.debug("Creating MBean for Server " + server);
        }
        if (server instanceof StandardServer) {
            ((StandardServer)server).addPropertyChangeListener(this);
        }
        if ((resources = server.getGlobalNamingResources()) != null) {
            this.createMBeans(resources);
        }
        Service[] services = server.findServices();
        for (int i = 0; i < services.length; ++i) {
            if (services[i].getContainer().getClass().getName().equals("org.apache.catalina.connector.warp.WarpEngine")) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Skipping MBean for Service " + services[i]);
                continue;
            }
            this.createMBeans(services[i]);
        }
    }

    protected void createMBeans(Service service) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Creating MBean for Service " + service);
        }
        if (service instanceof StandardService) {
            ((StandardService)service).addPropertyChangeListener(this);
        }
        Connector[] connectors = service.findConnectors();
        for (int j = 0; j < connectors.length; ++j) {
            this.createMBeans(connectors[j]);
        }
        Engine engine = (Engine)service.getContainer();
        if (engine != null) {
            this.createMBeans(engine);
        }
    }

    protected void destroyMBeans(Connector connector, Service service) throws Exception {
    }

    protected void destroyMBeans(Context context) throws Exception {
        NamingResources resources;
        Loader cLoader;
        Manager cManager;
        context.removeContainerListener(this);
        Realm hRealm = context.getParent().getRealm();
        Realm cRealm = context.getRealm();
        if (cRealm != null && cRealm != hRealm && log.isDebugEnabled()) {
            log.debug("Destroying MBean for Realm " + cRealm);
        }
        if ((cManager = context.getManager()) != null && log.isDebugEnabled()) {
            log.debug("Destroying MBean for Manager " + cManager);
        }
        Logger hLogger = context.getParent().getLogger();
        Logger cLogger = context.getLogger();
        if (cLogger != null && cLogger != hLogger && log.isDebugEnabled()) {
            log.debug("Destroying MBean for Logger " + cLogger);
        }
        if ((cLoader = context.getLoader()) != null && log.isDebugEnabled()) {
            log.debug("Destroying MBean for Loader " + cLoader);
        }
        if ((resources = context.getNamingResources()) != null) {
            this.destroyMBeans(resources);
        }
        if (log.isDebugEnabled()) {
            log.debug("Destroying MBean for Context " + context);
        }
        if (context instanceof StandardContext) {
            ((StandardContext)context).removePropertyChangeListener(this);
        }
    }

    protected void destroyMBeans(ContextEnvironment environment) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Destroying MBean for ContextEnvironment " + environment);
        }
        MBeanUtils.destroyMBean(environment);
    }

    protected void destroyMBeans(ContextResource resource) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Destroying MBean for ContextResource " + resource);
        }
        MBeanUtils.destroyMBean(resource);
    }

    protected void destroyMBeans(ContextResourceLink resourceLink) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Destroying MBean for ContextResourceLink " + resourceLink);
        }
        MBeanUtils.destroyMBean(resourceLink);
    }

    protected void destroyMBeans(DefaultContext dcontext) throws Exception {
        NamingResources resources;
        Loader dLoader;
        Manager dManager = dcontext.getManager();
        if (dManager != null && log.isDebugEnabled()) {
            log.debug("Destroying MBean for Manager " + dManager);
        }
        if ((dLoader = dcontext.getLoader()) != null && log.isDebugEnabled()) {
            log.debug("Destroying MBean for Loader " + dLoader);
        }
        if ((resources = dcontext.getNamingResources()) != null) {
            this.destroyMBeans(resources);
        }
        if (log.isDebugEnabled()) {
            log.debug("Destroying MBean for Context " + dcontext);
        }
        MBeanUtils.destroyMBean(dcontext);
        dcontext.removePropertyChangeListener(this);
    }

    protected void destroyMBeans(Engine engine) throws Exception {
        Logger eLogger;
        engine.removeContainerListener(this);
        Container[] hosts = engine.findChildren();
        for (int k = 0; k < hosts.length; ++k) {
            this.destroyMBeans((Host)hosts[k]);
        }
        Realm eRealm = engine.getRealm();
        if (eRealm != null && log.isDebugEnabled()) {
            log.debug("Destroying MBean for Realm " + eRealm);
        }
        if ((eLogger = engine.getLogger()) != null && log.isDebugEnabled()) {
            log.debug("Destroying MBean for Logger " + eLogger);
        }
        if (log.isDebugEnabled()) {
            log.debug("Destroying MBean for Engine " + engine);
        }
    }

    protected void destroyMBeans(Host host) throws Exception {
        host.removeContainerListener(this);
        Container[] contexts = host.findChildren();
        for (int k = 0; k < contexts.length; ++k) {
            this.destroyMBeans((Context)contexts[k]);
        }
        Realm eRealm = host.getParent().getRealm();
        Realm hRealm = host.getRealm();
        if (hRealm != null && hRealm != eRealm && log.isDebugEnabled()) {
            log.debug("Destroying MBean for Realm " + hRealm);
        }
        Logger eLogger = host.getParent().getLogger();
        Logger hLogger = host.getLogger();
        if (hLogger != null && hLogger != eLogger && log.isDebugEnabled()) {
            log.debug("Destroying MBean for Logger " + hLogger);
        }
        if (log.isDebugEnabled()) {
            log.debug("Destroying MBean for Host " + host);
        }
    }

    protected void destroyMBeans(NamingResources resources) throws Exception {
        ContextResource[] cresources = resources.findResources();
        for (int i = 0; i < cresources.length; ++i) {
            this.destroyMBeans(cresources[i]);
        }
        ContextResourceLink[] cresourcelinks = resources.findResourceLinks();
        for (int i = 0; i < cresourcelinks.length; ++i) {
            this.destroyMBeans(cresourcelinks[i]);
        }
        ContextEnvironment[] environments = resources.findEnvironments();
        for (int i = 0; i < environments.length; ++i) {
            this.destroyMBeans(environments[i]);
        }
        if (log.isDebugEnabled()) {
            log.debug("Destroying MBean for NamingResources " + resources);
        }
        MBeanUtils.destroyMBean(resources);
        resources.removePropertyChangeListener(this);
    }

    protected void destroyMBeans(Server server) throws Exception {
        NamingResources resources = server.getGlobalNamingResources();
        if (resources != null) {
            this.destroyMBeans(resources);
        }
        Service[] services = server.findServices();
        for (int i = 0; i < services.length; ++i) {
            if (services[i].getContainer().getClass().getName().equals("org.apache.catalina.connector.warp.WarpEngine")) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Skipping MBean for Service " + services[i]);
                continue;
            }
            this.destroyMBeans(services[i]);
        }
        if (log.isDebugEnabled()) {
            log.debug("Destroying MBean for Server " + server);
        }
        if (server instanceof StandardServer) {
            ((StandardServer)server).removePropertyChangeListener(this);
        }
    }

    protected void destroyMBeans(Service service) throws Exception {
        Engine engine = (Engine)service.getContainer();
        if (engine != null) {
            // empty if block
        }
        if (log.isDebugEnabled()) {
            log.debug("Destroying MBean for Service " + service);
        }
        if (service instanceof StandardService) {
            ((StandardService)service).removePropertyChangeListener(this);
        }
    }

    protected void processContainerAddChild(Container parent, Container child) {
        if (log.isDebugEnabled()) {
            log.debug("Process addChild[parent=" + parent + ",child=" + child + "]");
        }
        try {
            if (child instanceof Context) {
                this.createMBeans((Context)child);
            } else if (child instanceof Engine) {
                this.createMBeans((Engine)child);
            } else if (child instanceof Host) {
                this.createMBeans((Host)child);
            }
        }
        catch (MBeanException t) {
            Exception e = t.getTargetException();
            if (e == null) {
                e = t;
            }
            log.error("processContainerAddChild: MBeanException", e);
        }
        catch (Throwable t) {
            log.error("processContainerAddChild: Throwable", t);
        }
    }

    protected void processContainerPropertyChange(Container container, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("propertyChange[container=" + container + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]");
        }
        if ("defaultContext".equals(propertyName)) {
            if (oldValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Removing MBean for DefaultContext " + oldValue);
                }
                this.destroyMBeans((DefaultContext)oldValue);
            }
            if (newValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating MBean for DefaultContext " + newValue);
                }
                this.createMBeans((DefaultContext)newValue);
            }
        } else if ("loader".equals(propertyName)) {
            if (oldValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Removing MBean for Loader " + oldValue);
                }
                MBeanUtils.destroyMBean((Loader)oldValue);
            }
            if (newValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating MBean for Loader " + newValue);
                }
                MBeanUtils.createMBean((Loader)newValue);
            }
        } else if ("logger".equals(propertyName)) {
            if (oldValue != null && log.isDebugEnabled()) {
                log.debug("Removing MBean for Logger " + oldValue);
            }
            if (newValue != null && log.isDebugEnabled()) {
                log.debug("Creating MBean for Logger " + newValue);
            }
        } else if ("manager".equals(propertyName)) {
            if (oldValue != null && log.isDebugEnabled()) {
                log.debug("Removing MBean for Manager " + oldValue);
            }
            if (newValue != null && log.isDebugEnabled()) {
                log.debug("Creating MBean for Manager " + newValue);
            }
        } else if ("realm".equals(propertyName)) {
            if (oldValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Removing MBean for Realm " + oldValue);
                }
                MBeanUtils.destroyMBean((Realm)oldValue);
            }
            if (newValue != null && log.isDebugEnabled()) {
                log.debug("Creating MBean for Realm " + newValue);
            }
        } else if ("service".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Service)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((Service)newValue);
            }
        }
    }

    protected void processDefaultContextPropertyChange(DefaultContext defaultContext, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("propertyChange[defaultContext=" + defaultContext + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]");
        }
        if ("loader".equals(propertyName)) {
            if (oldValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Removing MBean for Loader " + oldValue);
                }
                MBeanUtils.destroyMBean((Loader)oldValue);
            }
            if (newValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating MBean for Loader " + newValue);
                }
                MBeanUtils.createMBean((Loader)newValue);
            }
        } else if ("logger".equals(propertyName)) {
            if (oldValue != null && log.isDebugEnabled()) {
                log.debug("Removing MBean for Logger " + oldValue);
            }
            if (newValue != null && log.isDebugEnabled()) {
                log.debug("Creating MBean for Logger " + newValue);
            }
        } else if ("manager".equals(propertyName)) {
            if (oldValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Removing MBean for Manager " + oldValue);
                }
                MBeanUtils.destroyMBean((Manager)oldValue);
            }
            if (newValue != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating MBean for Manager " + newValue);
                }
                MBeanUtils.createMBean((Manager)newValue);
            }
        } else if ("realm".equals(propertyName)) {
            if (oldValue != null) {
                // empty if block
            }
            if (newValue != null) {
                // empty if block
            }
        } else if ("service".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Service)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((Service)newValue);
            }
        }
    }

    protected void processContainerRemoveChild(Container parent, Container child) {
        if (log.isDebugEnabled()) {
            log.debug("Process removeChild[parent=" + parent + ",child=" + child + "]");
        }
        try {
            if (child instanceof Context) {
                Context context = (Context)child;
                if (context.getPrivileged()) {
                    context.getServletContext().removeAttribute("org.apache.catalina.Registry");
                    context.getServletContext().removeAttribute("org.apache.catalina.MBeanServer");
                }
                if (log.isDebugEnabled()) {
                    log.debug("  Removing MBean for Context " + context);
                }
                this.destroyMBeans(context);
                if (context instanceof StandardContext) {
                    ((StandardContext)context).removePropertyChangeListener(this);
                }
            } else if (child instanceof Host) {
                Host host = (Host)child;
                this.destroyMBeans(host);
                if (host instanceof StandardHost) {
                    ((StandardHost)host).removePropertyChangeListener(this);
                }
            }
        }
        catch (MBeanException t) {
            Exception e = t.getTargetException();
            if (e == null) {
                e = t;
            }
            log.error("processContainerRemoveChild: MBeanException", e);
        }
        catch (Throwable t) {
            log.error("processContainerRemoveChild: Throwable", t);
        }
    }

    protected void processNamingResourcesPropertyChange(NamingResources resources, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("propertyChange[namingResources=" + resources + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]");
        }
        if ("environment".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((ContextEnvironment)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((ContextEnvironment)newValue);
            }
        } else if ("resource".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((ContextResource)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((ContextResource)newValue);
            }
        } else if ("resourceLink".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((ContextResourceLink)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((ContextResourceLink)newValue);
            }
        }
    }

    protected void processServerPropertyChange(Server server, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("propertyChange[server=" + server + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]");
        }
        if ("globalNamingResources".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((NamingResources)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((NamingResources)newValue);
            }
        } else if ("service".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Service)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((Service)newValue);
            }
        }
    }

    protected void processServicePropertyChange(Service service, String propertyName, Object oldValue, Object newValue) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("propertyChange[service=" + service + ",propertyName=" + propertyName + ",oldValue=" + oldValue + ",newValue=" + newValue + "]");
        }
        if ("connector".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Connector)oldValue, service);
            }
            if (newValue != null) {
                this.createMBeans((Connector)newValue);
            }
        } else if ("container".equals(propertyName)) {
            if (oldValue != null) {
                this.destroyMBeans((Engine)oldValue);
            }
            if (newValue != null) {
                this.createMBeans((Engine)newValue);
            }
        }
    }
}

