/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.webservice.spi;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.webservice.ServiceRefDescUtil;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.enterprise.webservice.spi.InvInterfaceCreationListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.spi.ServiceDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDelegateImpl
extends ServiceDelegate {
    private ServiceDelegate delegate;
    private ArrayList<InvInterfaceCreationListener> listeners = new ArrayList();
    private ServiceReferenceDescriptor serviceRef;

    public ServiceDelegateImpl(ServiceDelegate delegate) {
        this.delegate = delegate;
        this.serviceRef = ServiceRefDescUtil.getReference();
    }

    public <T> T getPort(QName portName, Class<T> serviceEndpointInterface) {
        Object port = this.delegate.getPort(portName, serviceEndpointInterface);
        this.portCreated(port, serviceEndpointInterface);
        return (T)port;
    }

    public <T> T getPort(Class<T> serviceEndpointInterface) {
        Object port = this.delegate.getPort(serviceEndpointInterface);
        this.portCreated(port, serviceEndpointInterface);
        return (T)port;
    }

    public void addPort(QName portName, String bindingId, String endpointAddress) {
        this.delegate.addPort(portName, bindingId, endpointAddress);
    }

    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode) {
        Dispatch dispatch = this.delegate.createDispatch(portName, type, mode);
        this.dispatchCreated(dispatch, type);
        return dispatch;
    }

    public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode) {
        Dispatch dispatch = this.delegate.createDispatch(portName, context, mode);
        this.dispatchCreated(dispatch, Object.class);
        return dispatch;
    }

    public QName getServiceName() {
        return this.delegate.getServiceName();
    }

    public Iterator<QName> getPorts() {
        return this.delegate.getPorts();
    }

    public URL getWSDLDocumentLocation() {
        return this.delegate.getWSDLDocumentLocation();
    }

    public HandlerResolver getHandlerResolver() {
        return this.delegate.getHandlerResolver();
    }

    public void setHandlerResolver(HandlerResolver handlerResolver) {
        this.delegate.setHandlerResolver(handlerResolver);
    }

    public Executor getExecutor() {
        return this.delegate.getExecutor();
    }

    public void setExecutor(Executor executor) {
        this.delegate.setExecutor(executor);
    }

    private <T> void portCreated(T port, Class<T> serviceEndpointInterface) {
        for (InvInterfaceCreationListener listener : this.listeners) {
            try {
                listener.portCreated(port, serviceEndpointInterface);
            }
            catch (Throwable t) {
                WsUtil.getDefaultLogger().severe("Exception " + t.getMessage() + " in portCreationListener : " + listener);
                WsUtil.getDefaultLogger().log(Level.FINE, t.getMessage(), t);
            }
        }
    }

    public void addListener(InvInterfaceCreationListener listener) {
        this.listeners.add(listener);
    }

    private <T> void dispatchCreated(Dispatch<T> dispatch, Class<T> serviceEndpointInterface) {
        for (InvInterfaceCreationListener listener : this.listeners) {
            try {
                listener.dispatchCreated(dispatch, serviceEndpointInterface);
            }
            catch (Throwable t) {
                WsUtil.getDefaultLogger().severe("Exception " + t.getMessage() + " in dispatchCreationListener : " + listener);
                WsUtil.getDefaultLogger().log(Level.FINE, t.getMessage(), t);
            }
        }
    }

    public ServiceReferenceDescriptor getServiceReference() {
        return this.serviceRef;
    }
}

