/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.SelectorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer byteBuffer;
    private SelectionKey key = null;
    private int readTimeout = 15000;
    protected int readTry = 2;

    public ByteBufferInputStream() {
    }

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public int available() {
        return this.byteBuffer.remaining();
    }

    public void close() {
    }

    public boolean markSupported() {
        return true;
    }

    public int read() {
        if (!this.byteBuffer.hasRemaining()) {
            int eof = 0;
            for (int i = 0; i < this.readTry && (eof = this.doRead()) == 0; ++i) {
            }
        }
        return this.byteBuffer.hasRemaining() ? this.byteBuffer.get() & 0xFF : -1;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) {
        if (!this.byteBuffer.hasRemaining()) {
            int eof = 0;
            for (int i = 0; i < this.readTry && (eof = this.doRead()) == 0; ++i) {
            }
            if (eof <= 0) {
                return -1;
            }
        }
        if (length > this.byteBuffer.remaining()) {
            length = this.byteBuffer.remaining();
        }
        this.byteBuffer.get(b, offset, length);
        return length;
    }

    public void recycle() {
        this.byteBuffer = null;
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doRead() {
        if (this.key == null) {
            return -1;
        }
        this.byteBuffer.clear();
        int count = 1;
        int byteRead = 0;
        Selector readSelector = null;
        SelectionKey tmpKey = null;
        try {
            SocketChannel socketChannel = (SocketChannel)this.key.channel();
            while (count > 0) {
                count = socketChannel.read(this.byteBuffer);
                byteRead += count;
            }
            if (byteRead == 0) {
                readSelector = SelectorFactory.getSelector();
                if (readSelector == null) {
                    int n = 0;
                    return n;
                }
                count = 1;
                tmpKey = socketChannel.register(readSelector, 1);
                tmpKey.interestOps(tmpKey.interestOps() | 1);
                int code = readSelector.select(this.readTimeout);
                tmpKey.interestOps(tmpKey.interestOps() & 0xFFFFFFFE);
                if (code == 0) {
                    int ex = 0;
                    return ex;
                }
                while (count > 0) {
                    count = socketChannel.read(this.byteBuffer);
                    byteRead += count;
                }
            }
        }
        catch (Throwable t) {
            int n = -1;
            return n;
        }
        finally {
            if (tmpKey != null) {
                tmpKey.cancel();
            }
            if (readSelector != null) {
                try {
                    readSelector.selectNow();
                }
                catch (IOException ex) {}
                SelectorFactory.returnSelector(readSelector);
            }
        }
        this.byteBuffer.flip();
        return byteRead;
    }
}

