/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.collection;

import com.sun.enterprise.util.collection.DListNode;
import com.sun.enterprise.util.collection.DListNodeFactory;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class DList
implements List,
DListNodeFactory {
    protected DListNode first;
    protected DListNode last;
    protected int size = 0;
    protected DListNodeFactory nodeFactory;

    public DList() {
        this.first = new DListNode(null);
        this.first.next = this.last = new DListNode(null);
        this.last.prev = this.first;
        this.last.next = null;
        this.first.prev = null;
        this.nodeFactory = this;
    }

    public DList(DListNode firstNode, DListNode lastNode, DListNodeFactory factory) {
        this.initDListWithNodes(firstNode, lastNode, factory);
    }

    protected void initDListWithNodes(DListNode firstNode, DListNode lastNode, DListNodeFactory factory) {
        this.first = firstNode;
        this.first.next = this.last = lastNode;
        this.last.prev = this.first;
        this.last.next = null;
        this.first.prev = null;
        this.nodeFactory = factory == null ? this : factory;
    }

    public DList(DListNodeFactory nodeFactory) {
        this.first = new DListNode(null);
        this.first.next = this.last = new DListNode(null);
        this.last.prev = this.first;
        this.last.next = null;
        this.first.prev = null;
        this.nodeFactory = nodeFactory;
    }

    private DList(DListNode firstNode, DListNode lastNode, int size, DListNodeFactory nodeFactory) {
        this.first = firstNode;
        this.last = lastNode;
        this.size = size;
        this.nodeFactory = nodeFactory;
    }

    public void add(int index, Object object) {
        this.insertAt(index, object);
        ++this.size;
    }

    public boolean add(Object object) {
        this.last.insertBefore(this.nodeFactory.createDListNode(object));
        ++this.size;
        return true;
    }

    public boolean addAll(Collection collection) {
        Iterator iter = collection.iterator();
        boolean added = false;
        while (iter.hasNext()) {
            this.add(iter.next());
            added = true;
        }
        this.size += collection.size();
        return added;
    }

    public boolean addAll(int index, Collection collection) {
        DListNode head;
        DListNode node = this.getDListNodeAt(index);
        Iterator iter = collection.iterator();
        boolean added = iter.hasNext();
        DListNode last = head = new DListNode(null);
        while (iter.hasNext()) {
            last.insertAfter(this.nodeFactory.createDListNode(iter.next()));
            last = last.next;
        }
        if (head != last) {
            node.prev.next = head.next;
            node.prev = last;
            head.next.prev = node;
            last.next = node;
        }
        this.size += collection.size();
        return added;
    }

    public void clear() {
        this.first.next = this.last;
        this.last.prev = this.first;
        this.size = 0;
    }

    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    public boolean containsAll(Collection collection) {
        for (Object o : collection) {
            if (this.indexOf(o) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            if (list.size() != this.size()) {
                return false;
            }
            Object myObj = null;
            Object otherObj = null;
            DListNode node = this.first;
            for (int i = 0; i < this.size; ++i) {
                myObj = node.next.object;
                otherObj = list.get(i);
                if (!myObj.equals(otherObj)) {
                    return false;
                }
                node = node.next;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        DListNode node = this.first;
        Object myObj = null;
        for (int i = 0; i < this.size; ++i) {
            myObj = node.next.object;
            hashCode = 31 * hashCode + (myObj == null ? 0 : myObj.hashCode());
            node = node.next;
        }
        return hashCode;
    }

    public Object get(int index) {
        DListNode node = this.getDListNodeAt(index);
        return node == null ? null : node.object;
    }

    public int indexOf(Object o) {
        int index = 0;
        DListNode node = this.first.next;
        while (node != this.last) {
            if (node.object.equals(o)) {
                return index;
            }
            ++index;
            node = node.next;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size > 0;
    }

    public Iterator iterator() {
        return new DListIterator(this.first, this.last, false, 0);
    }

    public int lastIndexOf(Object obj) {
        int index = this.size - 1;
        DListNode node = this.last.prev;
        while (node != this.first) {
            if (node.object.equals(obj)) {
                return index;
            }
            --index;
            node = node.prev;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return new DListIterator(this.first, this.last, true, 0);
    }

    public ListIterator listIterator(int index) {
        return new DListIterator(this.first, this.last, true, index);
    }

    public Object remove(int index) {
        DListNode node = this.getDListNodeAt(index);
        node.delink();
        --this.size;
        Object object = node.object;
        this.destroyDListNode(node);
        return object;
    }

    public boolean remove(Object object) {
        DListNode node = this.getDListNode(object);
        if (node == null) {
            return false;
        }
        node.delink();
        this.destroyDListNode(node);
        --this.size;
        return true;
    }

    public boolean removeAll(Collection collection) {
        Iterator iter = collection.iterator();
        boolean removed = false;
        while (iter.hasNext()) {
            if (!this.remove(iter.next())) continue;
            --this.size;
            removed = true;
        }
        return removed;
    }

    public boolean retainAll(Collection collection) {
        boolean removed = false;
        DListNode node = this.first;
        DListNode dnode = null;
        while (node.next != this.last) {
            dnode = node.next;
            if (collection.contains(dnode.object)) {
                dnode.delink();
                this.destroyDListNode(dnode);
                --this.size;
                removed = true;
                continue;
            }
            node = node.next;
        }
        return removed;
    }

    public Object set(int index, Object object) {
        DListNode node = this.getDListNodeAt(index);
        Object oldObject = node == null ? null : node.object;
        node.object = object;
        return oldObject;
    }

    public DListNode insertAt(int index, Object object) {
        int i;
        if (index < 0 || index >= this.size) {
            return null;
        }
        int mid = this.size >> 1;
        DListNode node = null;
        if (index <= mid) {
            node = this.first.next;
            for (i = 0; i < index; ++i) {
                node = node.next;
            }
        } else {
            index = this.size - index - 1;
            node = this.last.prev;
            for (i = 0; i < index; ++i) {
                node = node.prev;
            }
        }
        DListNode newNode = this.nodeFactory.createDListNode(object);
        node.insertBefore(newNode);
        ++this.size;
        return newNode;
    }

    public int size() {
        return this.size;
    }

    public List subList(int fromIndex, int toIndex) {
        System.out.println("subList(" + fromIndex + ", " + toIndex + ")");
        DListNode startNode = this.getDListNodeAt(fromIndex);
        System.out.println("nodeAt(" + fromIndex + "): " + startNode.object);
        DListNode toNode = this.getDListNodeAt(toIndex);
        System.out.println("nodeAt(" + toIndex + "): " + toNode.object);
        return new DList(startNode.prev, toNode, toIndex - fromIndex, this.nodeFactory);
    }

    public Object[] toArray() {
        Object[] array = new Object[this.size];
        int index = 0;
        DListNode node = this.first.next;
        while (node != this.last) {
            array[index++] = node.object;
            node = node.next;
        }
        return array;
    }

    public Object[] toArray(Object[] array) {
        if (array.length < this.size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size);
        }
        int index = 0;
        DListNode node = this.first.next;
        while (node != this.last) {
            array[index++] = node.object;
            node = node.next;
        }
        if (array.length > this.size) {
            array[this.size] = null;
        }
        return array;
    }

    public DListNode createDListNode(Object object) {
        return new DListNode(object);
    }

    public void destroyDListNode(DListNode node) {
    }

    public DListNodeFactory getDListNodeFactory() {
        return this.nodeFactory;
    }

    public void setDListNodeFactory(DListNodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public void addAsFirstNode(DListNode node) {
        DListNode fNode;
        node.next = fNode = this.first.next;
        node.prev = this.first;
        fNode.prev = this.first.next = node;
        ++this.size;
    }

    public DListNode addAsFirstObject(Object object) {
        DListNode node = this.nodeFactory.createDListNode(object);
        this.addAsFirstNode(node);
        return node;
    }

    public void addAsLastNode(DListNode node) {
        DListNode lNode = this.last.prev;
        node.next = this.last;
        node.prev = lNode;
        lNode.next = this.last.prev = node;
        ++this.size;
    }

    public DListNode addAsLastObject(Object obj) {
        DListNode node = this.nodeFactory.createDListNode(obj);
        this.addAsLastNode(node);
        return node;
    }

    public DListNode delinkFirstNode() {
        if (this.size > 0) {
            DListNode node = this.first.next;
            node.delink();
            --this.size;
            return node;
        }
        return null;
    }

    public Object removeFirstObject() {
        DListNode node = this.delinkFirstNode();
        if (node == null) {
            return null;
        }
        Object object = node.object;
        this.destroyDListNode(node);
        return object;
    }

    public DListNode delinkLastNode() {
        if (this.size > 0) {
            DListNode node = this.last.prev;
            node.delink();
            --this.size;
            return node;
        }
        return null;
    }

    public Object removeLastObject() {
        DListNode node = this.delinkLastNode();
        if (node == null) {
            return null;
        }
        Object object = node.object;
        this.destroyDListNode(node);
        return object;
    }

    public DListNode getDListNode(Object o) {
        DListNode node = this.first.next;
        while (node != this.last) {
            if (node.object.equals(o)) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    public void delink(DListNode node) {
        node.delink();
        --this.size;
    }

    public DListNode getDListNodeAt(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException("DList size: " + this.size + "; index: " + index);
        }
        int mid = this.size >> 1;
        DListNode node = null;
        if (index <= mid) {
            node = this.first.next;
            for (int i = 0; i < index; ++i) {
                node = node.next;
            }
        } else {
            index = this.size - index - 1;
            node = this.last.prev;
            for (int i = 0; i < index; ++i) {
                node = node.prev;
            }
        }
        return node;
    }

    public DListNode getFirstDListNode() {
        return this.size == 0 ? null : this.first.next;
    }

    public DListNode getLastDListNode() {
        return this.size == 0 ? null : this.last.prev;
    }

    public DListNode getNextNode(DListNode node) {
        DListNode nextNode = node.next;
        return nextNode == this.last ? null : nextNode;
    }

    public DListNode getPreviousNode(DListNode node) {
        DListNode prevNode = node.prev;
        return prevNode == this.first ? null : prevNode;
    }

    public Iterator nodeIterator() {
        return new DListIterator(this.first, this.last, true, 0);
    }

    private class DListIterator
    implements ListIterator {
        DListNode firstNode;
        DListNode lastNode;
        DListNode currentNode;
        boolean toReturnNode;
        int currentIndex = -1;

        DListIterator(DListNode firstNode, DListNode lastNode, boolean toReturnNode, int skip) {
            this.firstNode = this.currentNode = firstNode;
            this.lastNode = lastNode;
            this.toReturnNode = toReturnNode;
            for (int i = 0; i < skip; ++i) {
                this.currentNode = this.currentNode.next;
            }
            this.currentIndex = skip;
        }

        DListIterator(int startIndex, int endIndex, boolean toReturnNode, int skip) {
            this.firstNode = this.currentNode = this.firstNode;
            this.lastNode = DList.this.getDListNodeAt(endIndex);
            this.toReturnNode = toReturnNode;
            for (int i = 0; i < skip; ++i) {
                this.currentNode = this.currentNode.next;
            }
            this.currentIndex = skip;
        }

        public void add(Object obj) {
            this.currentNode.insertAfter(DList.this.nodeFactory.createDListNode(obj));
        }

        public boolean hasNext() {
            return this.currentNode.next != this.lastNode;
        }

        public boolean hasPrevious() {
            return this.currentNode != this.firstNode;
        }

        public Object next() {
            if (this.currentNode.next == this.lastNode) {
                throw new NoSuchElementException("No next after this element");
            }
            this.currentNode = this.currentNode.next;
            ++this.currentIndex;
            return this.toReturnNode ? this.currentNode : this.currentNode.object;
        }

        public int nextIndex() {
            return this.currentIndex + 1;
        }

        public Object previous() {
            if (this.currentNode == this.firstNode) {
                throw new NoSuchElementException("No previous before this element");
            }
            DListNode node = this.currentNode;
            this.currentNode = this.currentNode.prev;
            --this.currentIndex;
            return this.toReturnNode ? node : node.object;
        }

        public int previousIndex() {
            return this.currentIndex - 1;
        }

        public void remove() {
            throw new UnsupportedOperationException("list.remove() not supported by DList iterator....");
        }

        public void set(Object o) {
            throw new UnsupportedOperationException("list.remove() not supported by DList iterator....");
        }
    }
}

