/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyWrapper
implements Serializable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    protected boolean bTryDefaultFileOnEnvFailure = true;
    private boolean bLoaded = false;
    protected boolean bDebug = false;
    protected String properties_file_name = null;
    protected Properties props = null;

    public PropertyWrapper(String propertiesFileName, String envPropName, boolean bTryDefaultFileOnEnvFailure) {
        try {
            if (null != envPropName) {
                String envPropFile;
                SecurityManager sm = System.getSecurityManager();
                if (null != sm) {
                    sm.checkPropertyAccess(envPropName);
                }
                if (null != (envPropFile = System.getProperty(envPropName))) {
                    this.properties_file_name = envPropFile;
                    try {
                        this.loadProperties();
                    }
                    catch (IOException ioe) {
                        _logger.log(Level.SEVERE, "enterprise_util.dbgcntl_ioexception", ioe);
                    }
                }
            }
        }
        catch (SecurityException se) {
            _logger.log(Level.SEVERE, "iplanet_util.security_exception", new Object[]{this.properties_file_name, se});
        }
        if (!this.bLoaded && bTryDefaultFileOnEnvFailure && null != propertiesFileName) {
            try {
                this.properties_file_name = propertiesFileName;
                this.loadProperties();
            }
            catch (IOException ioe) {
                _logger.log(Level.SEVERE, "enterprise_util.dbgcntl_ioexception", ioe);
            }
        }
        if (this.bLoaded && this.bDebug) {
            _logger.log(Level.FINE, "PropertyWrapper using " + this.properties_file_name);
        } else if (!this.bLoaded && this.bDebug) {
            _logger.log(Level.FINE, "PropertyWrapper reports properties could not be loaded for env=" + envPropName + " or filename=" + propertiesFileName);
        }
    }

    public PropertyWrapper(String propertiesFileName, String envPropName) {
        this(propertiesFileName, envPropName, true);
    }

    public PropertyWrapper(String propertiesFileName) {
        this(propertiesFileName, null, true);
    }

    public PropertyWrapper(Properties props) {
        this.props = props;
    }

    public String getPropertiesFile() {
        return this.properties_file_name;
    }

    protected void loadProperties() throws IOException {
        this.props = new Properties();
        InputStream is = ClassLoader.getSystemResourceAsStream(this.properties_file_name);
        this.props.load(is);
        if (!this.props.isEmpty()) {
            this.bLoaded = true;
        }
    }

    protected String getProperty(String key) {
        return this.getProperty(key, null);
    }

    protected String getProperty(String key, String defaultVal) {
        return this.props.getProperty(key, defaultVal);
    }

    protected int getIntProperty(String key) {
        String str = this.getProperty(key);
        if (null == str) {
            return -1;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    protected int getIntProperty(String key, int defaultVal) {
        String str = this.getProperty(key);
        if (null == str) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    protected boolean getBooleanProperty(String key, boolean defaultVal) {
        String str = this.getProperty(key);
        if (null == str) {
            return defaultVal;
        }
        if (str.toLowerCase().startsWith("true")) {
            return true;
        }
        if (str.toLowerCase().startsWith("false")) {
            return false;
        }
        return defaultVal;
    }

    protected long getLongProperty(String key) {
        String str = this.getProperty(key);
        if (str == null) {
            return -1L;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    protected long getLongProperty(String key, long defaultVal) {
        String str = this.getProperty(key);
        if (str == null) {
            return defaultVal;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }
}

