/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.persistence;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.ArrayList;

public class JarNotFound
extends VerifierTest
implements VerifierCheck {
    public Result check(Descriptor descriptor) {
        Result result = this.getInitializedResult();
        result.setStatus(0);
        this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
        PersistenceUnitDescriptor pu = (PersistenceUnitDescriptor)PersistenceUnitDescriptor.class.cast(descriptor);
        File absolutePURootFile = this.getAbsolutePuRootFile(pu);
        this.logger.fine("Absolute PU Root: " + absolutePURootFile);
        String absolutePuRoot = absolutePURootFile.getAbsolutePath();
        ArrayList<String> jarFileNames = new ArrayList<String>(pu.getJarFiles());
        for (String jarFileName : jarFileNames) {
            String nativeJarFileName = jarFileName.replace('/', File.separatorChar);
            File parentFile = new File(absolutePuRoot).getParentFile();
            File jarFile = new File(parentFile, nativeJarFileName);
            if (jarFile.exists()) continue;
            String pathComponent = "";
            String nameComponent = jarFileName;
            if (jarFileName.lastIndexOf("../") != -1) {
                int separatorIndex = jarFileName.lastIndexOf("../") + 3;
                pathComponent = jarFileName.substring(0, separatorIndex);
                nameComponent = jarFileName.substring(separatorIndex);
            }
            this.logger.fine("For jar-file=" + jarFileName + ", " + "pathComponent=" + pathComponent + ", nameComponent=" + nameComponent);
            jarFile = new File(new File(parentFile, pathComponent), FileUtils.makeFriendlyFileName(nameComponent));
            if (jarFile.exists()) continue;
            result.failed(smh.getLocalString(this.getClass().getName() + "failed", "[ {0} ] specified in persistence.xml does not exist in the application.", new Object[]{jarFileName}));
        }
        return result;
    }

    private File getAbsolutePuRootFile(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        String applicationLocation = this.getVerifierContext().getAbstractArchive().getArchiveUri();
        File absolutePuRootFile = new File(applicationLocation, persistenceUnitDescriptor.getAbsolutePuRoot().replace('/', File.separatorChar));
        if (!absolutePuRootFile.exists()) {
            throw new RuntimeException(absolutePuRootFile.getAbsolutePath() + " does not exist!");
        }
        return absolutePuRootFile;
    }
}

