/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.elements;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;

public class EjbRefTypeElement
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean failed = false;
        if (!descriptor.getEjbReferenceDescriptors().isEmpty()) {
            for (EjbReferenceDescriptor ejbReferenceDescriptor : descriptor.getEjbReferenceDescriptors()) {
                String actualRefType;
                String refStr = ejbReferenceDescriptor.isLocal() ? "ejb-local-ref" : "ejb-ref";
                String beanType = descriptor.getType().toLowerCase();
                String xpathQuery = null;
                if (this.getVerifierContext().getDocument().getDoctype() != null) {
                    xpathQuery = "/ejb-jar/enterprise-beans/" + beanType + "[ejb-name=\"" + descriptor.getName() + "\"]/" + refStr + "[ejb-ref-name=\"" + ejbReferenceDescriptor.getName() + "\"]/ejb-ref-type";
                } else {
                    String prefix = "xpathfake";
                    xpathQuery = prefix + ":" + "ejb-jar/" + prefix + ":" + "enterprise-beans/" + prefix + ":" + beanType + "[" + prefix + ":ejb-name=\"" + descriptor.getName() + "\"]/" + prefix + ":" + refStr + "[" + prefix + ":ejb-ref-name=\"" + ejbReferenceDescriptor.getName() + "\"]/" + prefix + ":" + "ejb-ref-type";
                }
                String ejbRefTypeStr = this.getXPathValueForNonRuntime(xpathQuery);
                EjbDescriptor rdesc = ejbReferenceDescriptor.getEjbDescriptor();
                if (ejbRefTypeStr == null) {
                    ejbRefTypeStr = ejbReferenceDescriptor.getType();
                }
                if (!ejbRefTypeStr.equals("Session") && !ejbRefTypeStr.equals(EjbEntityDescriptor.TYPE)) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: ejb-ref-type [ {0} ] within \n bean [ {1} ] is not valid.  \n Must be [ {2} ] or [ {3} ]", new Object[]{ejbRefTypeStr, descriptor.getName(), EjbEntityDescriptor.TYPE, "Session"}));
                    failed = true;
                    continue;
                }
                if (rdesc == null || ejbRefTypeStr.equals(actualRefType = rdesc.getType())) continue;
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "Error: ejb-ref-type [ {0} ] was specifed for ejb-ref [ {1} ], within bean [ {2} ], when it should have been [ {3} ].", new Object[]{ejbRefTypeStr, ejbReferenceDescriptor.getName(), descriptor.getName(), actualRefType}));
                failed = true;
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no ejb references to other beans within this bean [ {0} ]", new Object[]{descriptor.getName()}));
            return result;
        }
        if (failed) {
            result.setStatus(1);
        } else {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All ejb-ref-type elements are valid.  They are all [ {0} ] or [ {1} ] within this bean [ {2} ]", new Object[]{EjbEntityDescriptor.TYPE, "Session", descriptor.getName()}));
        }
        return result;
    }
}

