/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.util.diagnostics;

import com.sun.enterprise.tools.common.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class Profiler {
    Item currItem = null;
    List items = new ArrayList();

    public void beginItem() {
        this.beginItem("No Description");
    }

    public void beginItem(String desc) {
        this.currItem = new Item(desc);
        this.items.add(this.currItem);
    }

    public void endItem() {
        Item item = this.getLastNotEnded();
        if (item != null) {
            item.end();
        }
    }

    public void report() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(Item.getHeader());
        sb.append("\n\n");
        for (Item item : this.items) {
            sb.append(item.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private Item getLastNotEnded() {
        int index = this.items.size();
        while (--index >= 0) {
            Item item = (Item)this.items.get(index);
            if (item.hasEnded()) continue;
            return item;
        }
        return null;
    }

    public static void main(String[] notUsed) {
        Profiler p = new Profiler();
        try {
            p.beginItem("first item");
            Thread.sleep(3000L);
            p.beginItem("second item here dude whoa yowser yowser");
            Thread.sleep(1500L);
            p.endItem();
            p.endItem();
            System.out.println("" + p);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class Item {
        String title;
        long startTime;
        long endTime;
        static int longestTitle = 12;

        Item(String desc) {
            this.title = desc;
            this.endTime = this.startTime = System.currentTimeMillis();
            if (this.title.length() > longestTitle) {
                longestTitle = this.title.length();
            }
        }

        boolean hasEnded() {
            return this.endTime > this.startTime;
        }

        void end() {
            this.endTime = System.currentTimeMillis();
        }

        public String toString() {
            long finish = this.hasEnded() ? this.endTime : System.currentTimeMillis();
            String desc = StringUtils.padRight(this.title, longestTitle + 1);
            String time = StringUtils.padLeft("" + (finish - this.startTime), 8);
            if (!this.hasEnded()) {
                time = time + "  ** STILL RUNNING **";
            }
            return desc + time;
        }

        public static String getHeader() {
            return StringUtils.padRight("Description", longestTitle + 1) + StringUtils.padLeft("msec", 8);
        }
    }
}

