/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ondemand;

import com.sun.enterprise.server.ondemand.OnDemandServer;
import com.sun.enterprise.server.ondemand.entry.EntryContext;
import com.sun.enterprise.server.ondemand.entry.ServerEntryListener;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerEntryListenerImpl
implements ServerEntryListener {
    private OnDemandServer server = null;
    private ArrayList listeners = new ArrayList();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public ServerEntryListenerImpl(OnDemandServer server) {
        this.server = server;
    }

    public boolean isNotified(EntryContext context) {
        ServerEntryListenerImpl serverEntryListenerImpl = this;
        context.setServerContext(serverEntryListenerImpl.server.getServerContext());
        return this.server.getServiceGroup().isNotified(context);
    }

    public void notifyEntry(EntryContext context) {
        ServerEntryListenerImpl serverEntryListenerImpl = this;
        if (serverEntryListenerImpl.server.isOnDemandOff() && context.getEntryPointType() != 5) {
            return;
        }
        ServerEntryListenerImpl serverEntryListenerImpl2 = this;
        context.setServerContext(serverEntryListenerImpl2.server.getServerContext());
        try {
            this.server.getServiceGroup().start(context);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, e.getMessage(), e);
        }
        for (ServerEntryListener listener : this.listeners) {
            listener.notifyEntry(context);
        }
    }

    public void addServerEntryListener(ServerEntryListener listener) {
        this.listeners.add(listener);
    }

    public void removeServerEntryListener(ServerEntryListener listener) {
        this.listeners.remove(listener);
    }
}

