/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.server.AbstractLoader;
import com.sun.logging.LogDomains;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MBeanException;

class EJBModuleLoader
extends AbstractLoader {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.classloading");

    EJBModuleLoader(String modID, ClassLoader parentClassLoader, EjbModulesManager ejbModulesManager) {
        super(modID, parentClassLoader, ejbModulesManager);
        boolean createClassLoader = true;
        try {
            this.application = ejbModulesManager.getRegisteredDescriptor(modID);
            if (this.application == null) {
                this.application = ejbModulesManager.getDescriptor(modID, parentClassLoader);
                createClassLoader = false;
            } else {
                try {
                    ClassLoader clazzloader = this.application.getClassLoader();
                    if (clazzloader != null && clazzloader instanceof EJBClassLoader && !((EJBClassLoader)clazzloader).isDone()) {
                        createClassLoader = false;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (createClassLoader) {
                String[] classPath = EJBClassPathUtils.getModuleClasspath(modID, null, ejbModulesManager).toArray(new String[0]);
                this.initializeLoader(classPath, ejbModulesManager.getLocation(modID), ModuleType.EJB);
                this.application.setClassLoader(this.ejbClassLoader);
                if (this.application.isVirtual()) {
                    BundleDescriptor bd = this.application.getStandaloneBundleDescriptor();
                    bd.setClassLoader(this.ejbClassLoader);
                }
            } else {
                this.initializeLoader(this.application.getClassLoader());
            }
        }
        catch (Exception confEx) {
            _logger.log(Level.SEVERE, "ERROR while loading application " + modID);
            _logger.log(Level.SEVERE, "loader.error_while_loading_app_desc", confEx);
        }
    }

    boolean load(boolean jsr77) {
        boolean status;
        this.notifyAppEvent(0);
        boolean pusLoaded = false;
        if (this.application.isVirtual()) {
            if (!this.loadPersistenceUnits()) {
                return false;
            }
            pusLoaded = true;
        }
        if (status = this.loadEjbs(jsr77)) {
            this.notifyAppEvent(1);
            this.loadWebserviceEndpoints(jsr77);
        } else if (pusLoaded) {
            this.unloadPersistenceUnits();
        }
        return status;
    }

    boolean unload(boolean jsr77) {
        this.notifyAppEvent(2);
        boolean result = this.unloadEjbs(jsr77);
        this.unloadWebserviceEndpoints(jsr77);
        if (this.application.isVirtual()) {
            result &= this.unloadPersistenceUnits();
        }
        this.configManager.unregisterDescriptor(this.id);
        this.notifyAppEvent(3);
        this.done();
        return result;
    }

    void createRootMBean() throws MBeanException {
        Object eddf = null;
        Set ejbBundles = this.application.getEjbBundleDescriptors();
        for (EjbBundleDescriptor bundleDesc : ejbBundles) {
            try {
                Switch.getSwitch().getManagementObjectManager().createEJBModuleMBean(bundleDesc, this.configManager.getInstanceEnvironment().getName(), this.configManager.getLocation(this.id));
            }
            catch (Exception e) {
                throw new MBeanException(e);
            }
        }
    }

    void deleteRootMBean() throws MBeanException {
        Set ejbBundles = this.application.getEjbBundleDescriptors();
        for (EjbBundleDescriptor bundleDesc : ejbBundles) {
            Switch.getSwitch().getManagementObjectManager().deleteEJBModuleMBean(bundleDesc, this.configManager.getInstanceEnvironment().getName());
        }
    }

    void createLeafMBeans() throws MBeanException {
        Set ejbBundles = this.application.getEjbBundleDescriptors();
        for (EjbBundleDescriptor bundleDesc : ejbBundles) {
            Switch.getSwitch().getManagementObjectManager().createEJBMBeans(bundleDesc, this.configManager.getInstanceEnvironment().getName());
        }
    }

    void createLeafMBean(Descriptor descriptor) throws MBeanException {
        EjbDescriptor ejbDescriptor = null;
        try {
            ejbDescriptor = (EjbDescriptor)descriptor;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        Switch.getSwitch().getManagementObjectManager().createEJBMBean(ejbDescriptor, this.configManager.getInstanceEnvironment().getName());
    }

    void deleteLeafMBeans() throws MBeanException {
        Set ejbBundles = this.application.getEjbBundleDescriptors();
        for (EjbBundleDescriptor bundleDesc : ejbBundles) {
            Switch.getSwitch().getManagementObjectManager().deleteEJBMBeans(bundleDesc, this.configManager.getInstanceEnvironment().getName());
        }
    }

    void deleteLeafMBean(Descriptor descriptor) throws MBeanException {
        EjbDescriptor ejbDescriptor = null;
        try {
            ejbDescriptor = (EjbDescriptor)descriptor;
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        Switch.getSwitch().getManagementObjectManager().deleteEJBMBean(ejbDescriptor, this.configManager.getInstanceEnvironment().getName());
    }

    void deleteLeafAndRootMBeans() throws MBeanException {
        this.deleteLeafMBeans();
        this.deleteRootMBean();
    }

    void setState(int state) throws MBeanException {
        Set ejbBundles = this.application.getEjbBundleDescriptors();
        for (EjbBundleDescriptor bundleDesc : ejbBundles) {
            Switch.getSwitch().getManagementObjectManager().setEJBModuleState(state, bundleDesc, this.configManager.getInstanceEnvironment().getName());
        }
    }
}

