/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeployerFactory;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.MonitorListener;
import com.sun.enterprise.server.MonitorableEntry;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

class AutoDeployer
implements MonitorListener {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    AutoDeployer() {
    }

    public boolean reload(MonitorableEntry entry) {
        return false;
    }

    public boolean deploy(MonitorableEntry entry, File archive) {
        boolean status = false;
        try {
            DeploymentRequest req = this.deploy(archive);
            status = true;
        }
        catch (IASDeploymentException de) {
            _logger.log(Level.WARNING, "core.exception", de);
            status = false;
        }
        return status;
    }

    private DeploymentRequest deploy(File archive) throws IASDeploymentException {
        InstanceEnvironment env = ApplicationServer.getServerContext().getInstanceEnvironment();
        DeployableObjectType type = null;
        if (FileUtils.isEar(archive)) {
            type = DeployableObjectType.APP;
        } else if (FileUtils.isJar(archive)) {
            type = DeployableObjectType.EJB;
        } else if (FileUtils.isWar(archive)) {
            type = DeployableObjectType.WEB;
        } else if (FileUtils.isRar(archive)) {
            type = DeployableObjectType.CONN;
        }
        DeploymentRequest req = new DeploymentRequest(env, type, DeploymentCommand.DEPLOY);
        req.setFileSource(archive);
        String fileName = archive.getName();
        int dotIdx = fileName.indexOf(fileName);
        String regName = fileName.substring(0, dotIdx);
        req.setName(regName);
        if (type.isWEB()) {
            req.setContextRoot(regName);
        }
        req.setForced(true);
        Deployer deployer = DeployerFactory.getDeployer(req);
        deployer.doRequest();
        deployer.cleanup();
        return req;
    }
}

