/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.ejb.Container;
import com.sun.ejb.ContainerFactory;
import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.server.ApplicationManager;
import com.sun.enterprise.server.ApplicationRegistry;
import com.sun.enterprise.server.ConnectorResourcesLoader;
import com.sun.enterprise.server.DummyWebModuleManager;
import com.sun.enterprise.server.ManagerFactory;
import com.sun.enterprise.server.ReloadMonitor;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.StandAloneAppClientModulesManager;
import com.sun.enterprise.server.StandAloneConnectorModulesManager;
import com.sun.enterprise.server.StandAloneEJBModulesManager;
import com.sun.logging.LogDomains;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ApplicationLifecycle
implements ServerLifecycle {
    protected ServerContext _context = null;
    protected ApplicationManager _applicationMgr = null;
    protected StandAloneEJBModulesManager _ejbMgr = null;
    protected StandAloneConnectorModulesManager _connMgr = null;
    protected ConnectorResourcesLoader _connectorResLoader = null;
    protected StandAloneAppClientModulesManager _acMgr = null;
    protected DummyWebModuleManager _webMgr = null;
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core");

    public void onInitialization(ServerContext sc) throws ServerLifecycleException {
        this._context = sc;
        try {
            this._applicationMgr = ManagerFactory.getApplicationManager();
            this._ejbMgr = ManagerFactory.getSAEJBModulesManager();
            this._webMgr = ManagerFactory.getSAWebModulesManager();
            this._connMgr = ManagerFactory.getSAConnectorModulesManager();
            this._connectorResLoader = new ConnectorResourcesLoader(sc);
            this._acMgr = ManagerFactory.getSAACModulesManager();
        }
        catch (ConfigException confEx) {
            _logger.log(Level.SEVERE, "core.config_exception_while_app_loading", confEx);
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "core.unexpected_error_occured_while_app_loading", th);
        }
    }

    public void onStartup(ServerContext sc) throws ServerLifecycleException {
        try {
            this._connectorResLoader.loadRAConfigs();
            this._connMgr.load();
            boolean standAloneRarsResources = true;
            this._connectorResLoader.load(standAloneRarsResources);
            ResourceInstaller installer = Switch.getSwitch().getResourceInstaller();
            installer.recoverXAResources();
            this._acMgr.load();
            this._ejbMgr.load();
            this._webMgr.load();
            this._applicationMgr.load();
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "core.unexpected_error_occured_while_app_loading", th);
        }
    }

    public void onReady(ServerContext sc) throws ServerLifecycleException {
        try {
            ApplicationRegistry registry = ApplicationRegistry.getInstance();
            Collection containers = null;
            if (registry != null) {
                containers = registry.getAllEjbContainers();
            }
            if (containers != null) {
                for (Container container : containers) {
                    if (container == null) continue;
                    container.onReady();
                }
            }
            _logger.log(Level.FINE, "core.application_onReady_complete");
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "core.unexpected_error_occured_while_app_onready", th);
        }
        ConfigContext configCtx = sc.getConfigContext();
        Object applicationsBean = null;
        DasConfig dasConfig = null;
        boolean monitor = false;
        try {
            dasConfig = ServerBeansFactory.getDasConfigBean(configCtx);
            monitor = dasConfig.isDynamicReloadEnabled();
        }
        catch (ConfigException ce) {
            _logger.log(Level.SEVERE, "core.config_exception_while_dynamic_reloading", ce);
            monitor = false;
        }
        if (monitor) {
            ReloadMonitor reloadMonitor = ReloadMonitor.getInstance(2000L);
            reloadMonitor.start();
        }
        ContainerFactory cf = Switch.getSwitch().getContainerFactory();
        try {
            cf.restoreEJBTimers();
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "ApplicationLifeCycle.onReady():: exception when calling restoreEJBTimers()", ex);
        }
    }

    public void onShutdown() throws ServerLifecycleException {
        if (this._applicationMgr == null) {
            return;
        }
        try {
            _logger.log(Level.INFO, "core.shutting_down_applications");
            this._applicationMgr.shutdown();
            ApplicationRegistry registry = ApplicationRegistry.getInstance();
            Collection containers = null;
            if (registry != null) {
                containers = registry.getAllEjbContainers();
            }
            if (containers != null) {
                for (Container container : containers) {
                    if (container == null) continue;
                    container.onShutdown();
                }
            }
            _logger.log(Level.INFO, "core.shutting_down_resource_adapters");
            this._connectorResLoader.stopActiveResourceAdapters();
            _logger.log(Level.INFO, "core.ra_shutdown_complete");
            _logger.log(Level.INFO, "core.application_shutdown_complete");
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "core.unexpected_error_occured_while_app_shutdown", th);
        }
    }

    public void onTermination() throws ServerLifecycleException {
        try {
            ApplicationRegistry registry = ApplicationRegistry.getInstance();
            Collection containers = null;
            if (registry != null) {
                containers = registry.getAllEjbContainers();
            }
            if (containers != null) {
                for (Container container : containers) {
                    if (container == null) continue;
                    container.onTermination();
                }
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "core.unexpected_error_occured_while_app_terminate", th);
        }
    }
}

