/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import java.io.IOException;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.tomcat.util.net.jsse.JSSE14SocketFactory;
import org.apache.tomcat.util.net.jsse.JSSEKeyManager;

public class NSSSocketFactory
extends JSSE14SocketFactory {
    public static final String INTERNAL_TOKEN = "NSS Certificate DB";

    protected KeyStore getKeystore(String type, String pass) throws IOException {
        String keyAlias = (String)this.attributes.get("keyAlias");
        String token = NSSSocketFactory.getTokenFromKeyAlias(keyAlias);
        SecuritySupport secSupp = SecurityUtil.getSecuritySupport();
        KeyStore ks = secSupp.getKeyStore(token);
        if (ks == null) {
            throw new IOException("keystore not found for token " + token);
        }
        return ks;
    }

    protected KeyStore getTrustStore(String keystoreType) throws IOException {
        try {
            return SSLUtils.mergingTrustStores(SecurityUtil.getSecuritySupport().getTrustStores());
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected KeyManager[] getKeyManagers(String keystoreType, String algorithm, String keyAlias) throws Exception {
        KeyManager[] kms = null;
        SecuritySupport secSupp = SecurityUtil.getSecuritySupport();
        String token = NSSSocketFactory.getTokenFromKeyAlias(keyAlias);
        String certAlias = NSSSocketFactory.getCertAliasFromKeyAlias(keyAlias);
        String keystorePass = secSupp.getKeyStorePassword(token);
        KeyStore ks = secSupp.getKeyStore(token);
        if (ks == null) {
            throw new IOException("keystore not found for token " + token);
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keystorePass.toCharArray());
        kms = kmf.getKeyManagers();
        for (int i = 0; certAlias != null && i < kms.length; ++i) {
            kms[i] = new JSSEKeyManager((X509KeyManager)kms[i], certAlias);
        }
        return kms;
    }

    private static String getTokenFromKeyAlias(String keyAlias) {
        int idx;
        String token = null;
        if (keyAlias != null && (idx = keyAlias.indexOf(58)) != -1) {
            token = keyAlias.substring(0, idx);
        }
        token = token == null ? INTERNAL_TOKEN : token.trim();
        return token;
    }

    private static String getCertAliasFromKeyAlias(String keyAlias) {
        String certAlias = null;
        if (keyAlias != null) {
            int idx = keyAlias.indexOf(58);
            if (idx == -1) {
                certAlias = keyAlias;
            } else if (++idx < keyAlias.length() - 1) {
                certAlias = keyAlias.substring(idx);
            }
        }
        if (certAlias != null) {
            certAlias = certAlias.trim();
        }
        return certAlias;
    }
}

