/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.instance;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.util.ModuleContentLinker;
import com.sun.enterprise.instance.ApplicationEnvironment;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.ExceptionType;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.Localizer;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.loader.InstrumentableClassLoader;
import com.sun.enterprise.util.io.FileUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;

public class AppsManager
extends BaseManager {
    private static Map apps = null;

    public AppsManager(InstanceEnvironment env) throws ConfigException {
        super(env, true);
    }

    public AppsManager(InstanceEnvironment env, boolean useBackupServerXml) throws ConfigException {
        super(env, useBackupServerXml);
        J2eeApplication[] jArray = ((Applications)this.configBean).getJ2eeApplication();
        if (jArray != null) {
            for (int i = 0; i < jArray.length; ++i) {
                jArray[i].setConfigContext(this.configContext);
                jArray[i].setXPath(ServerXPathHelper.getAppIdXpathExpression(jArray[i].getName()));
            }
        }
    }

    public ModuleType getModuleType() {
        return ModuleType.EAR;
    }

    public String getStubLocation(String appId) {
        ApplicationEnvironment env = this.instanceEnvironment.getApplicationEnvironment(appId);
        return env.getAppStubPath();
    }

    public String getGeneratedXMLLocation(String name) {
        ApplicationEnvironment env = this.instanceEnvironment.getApplicationEnvironment(name);
        return env.getAppGeneratedXMLPath();
    }

    public String getJSPLocation(String appId) {
        ApplicationEnvironment env = this.instanceEnvironment.getApplicationEnvironment(appId);
        return env.getAppJSPPath();
    }

    public J2eeApplication[] getAllApps() {
        J2eeApplication[] apps = ((Applications)this.configBean).getJ2eeApplication();
        if (apps == null) {
            return new J2eeApplication[0];
        }
        ArrayList<J2eeApplication> list = new ArrayList<J2eeApplication>();
        for (int i = 0; i < apps.length; ++i) {
            if (!this.isReferenced(apps[i].getName())) continue;
            list.add(apps[i]);
        }
        J2eeApplication[] refList = new J2eeApplication[list.size()];
        return list.toArray(refList);
    }

    public List listIds() {
        ArrayList<String> arr = new ArrayList<String>();
        J2eeApplication[] apps = ((Applications)this.configBean).getJ2eeApplication();
        if (apps == null) {
            return arr;
        }
        for (int i = 0; i < apps.length; ++i) {
            String name = apps[i].getName();
            if (!this.isReferenced(name)) continue;
            arr.add(name);
        }
        return arr;
    }

    public String getLocation(String appId) throws ConfigException {
        J2eeApplication app = ((Applications)this.configBean).getJ2eeApplicationByName(appId);
        String resolvedPath = new PropertyResolver(this.configContext, this.getInstanceEnvironment().getName()).resolve(app.getLocation());
        return resolvedPath;
    }

    public boolean isEnabled(String appId) throws ConfigException {
        return this.getJ2eeApplication(appId).isEnabled();
    }

    public boolean isJavaWebStartEnabled(String appId) throws ConfigException {
        J2eeApplication app = ((Applications)this.configBean).getJ2eeApplicationByName(appId);
        return app.isJavaWebStartEnabled();
    }

    public boolean isSystem(String appId) throws ConfigException {
        J2eeApplication ja = this.getJ2eeApplication(appId);
        String resourceType = ja.getObjectType();
        return resourceType.startsWith("system-");
    }

    public boolean isSystemAdmin(String appId) throws ConfigException {
        J2eeApplication ja = this.getJ2eeApplication(appId);
        String resourceType = ja.getObjectType();
        return resourceType.startsWith("system-admin");
    }

    protected boolean isRegistered(String appId, ConfigBean bean) {
        J2eeApplication cb = null;
        try {
            cb = ((Applications)bean).getJ2eeApplicationByName(appId);
        }
        catch (Exception cn) {
            // empty catch block
        }
        return cb != null;
    }

    public void remove(String appId) throws ConfigException {
        J2eeApplication backJa = ((Applications)this.configBean).getJ2eeApplicationByName(appId);
        ((Applications)this.configBean).removeJ2eeApplication(backJa);
    }

    public void setEnable(String appId, boolean enabled) throws ConfigException {
        this.getJ2eeApplication(appId).setEnabled(enabled);
    }

    public void setLocation(String appId, String location) throws ConfigException {
        this.getJ2eeApplication(appId).setLocation(location);
    }

    public void setOptionalAttributes(String appId, Properties optionalAttributes) throws ConfigException {
        if (optionalAttributes != null) {
            J2eeApplication ja = this.getJ2eeApplication(appId);
            Enumeration<Object> tags = optionalAttributes.keys();
            while (tags.hasMoreElements()) {
                String tag = (String)tags.nextElement();
                String value = optionalAttributes.getProperty(tag);
                ja.setAttributeValue(tag, value);
            }
        }
    }

    public Application getDescriptor(String appID, ClassLoader cl, String loc, boolean validateXML) throws ConfigException {
        return this.getRegisteredDescriptor(appID);
    }

    public Application getAppDescriptor(String appID, ClassLoader parentClassLoader) throws ConfigException {
        Application application = this.getRegisteredDescriptor(appID);
        if (application != null) {
            return application;
        }
        try {
            ApplicationArchivist archivist = new ApplicationArchivist();
            FileArchive appArchive = new FileArchive();
            appArchive.open(this.getLocation(appID));
            if (!archivist.hasStandardDeploymentDescriptor(appArchive)) {
                appArchive.open(this.getGeneratedXMLLocation(appID));
            }
            application = Application.createApplication(appArchive, false);
            application.setRegistrationName(appID);
            String moduleRoot = this.getLocation(application.getRegistrationName());
            String[] classPaths = EJBClassPathUtils.getAppClasspath(application, this).toArray(new String[0]);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[AppsManager] :: appID " + appID + " classpaths " + classPaths + " moduleRoot " + moduleRoot + " parentClassLoader " + parentClassLoader);
            }
            EJBClassLoader cl = EJBClassPathUtils.createEJBClassLoader(classPaths, moduleRoot, appID, parentClassLoader, application.getModuleType());
            application.setClassLoader(cl);
        }
        catch (Exception confEx) {
            _logger.log(Level.SEVERE, "loader.error_while_loading_app_desc", confEx);
            throw new ConfigException(confEx);
        }
        return this.getAppDescriptor(application);
    }

    public Application getAppDescriptor(Application application) throws ConfigException {
        if (application == null) {
            throw new ConfigException("Application object should not be null");
        }
        ClassLoader cl = application.getClassLoader();
        if (cl instanceof InstrumentableClassLoader) {
            ClassLoader tcl = ((InstrumentableClassLoader)InstrumentableClassLoader.class.cast(cl)).copy();
            application.setClassLoader(tcl);
            for (BundleDescriptor bd : application.getBundleDescriptors()) {
                bd.setClassLoader(tcl);
            }
        }
        String appId = application.getRegistrationName();
        try {
            String appDir = this.getLocation(appId);
            FileArchive in = new FileArchive();
            if (this.isSystemAdmin(appId)) {
                in.open(appDir);
            } else {
                String xmlDir = this.getGeneratedXMLLocation(appId);
                if (FileUtils.safeIsDirectory(xmlDir)) {
                    in.open(xmlDir);
                } else {
                    _logger.log(Level.WARNING, "core.no_xmldir", new Object[]{xmlDir, appDir});
                    in.open(appDir);
                }
            }
            ApplicationArchivist archivist = new ApplicationArchivist();
            archivist.readModulesDescriptors(application, in);
            archivist.readRuntimeDeploymentDescriptor(in, application);
            if (!this.isSystemAdmin(appId) && !this.isSystem(appId)) {
                this.readPersistenceDeploymentDescriptors(appDir, application);
            }
            archivist.setDescriptor(application);
            archivist.validate(application.getClassLoader());
            application.setGeneratedXMLDirectory(this.getGeneratedXMLLocation(appId));
            if (!application.getWebServiceDescriptors().isEmpty()) {
                ModuleContentLinker visitor = new ModuleContentLinker(in);
                application.visit(visitor);
            }
            application.setClassLoader(cl);
            for (BundleDescriptor bd : application.getBundleDescriptors()) {
                bd.setClassLoader(cl);
            }
            this.registerDescriptor(appId, application);
            return application;
        }
        catch (ConfigException ce) {
            throw ce;
        }
        catch (Throwable t) {
            throw new ConfigException(Localizer.getValue(ExceptionType.FAIL_DD_LOAD, appId), t);
        }
    }

    public String getDescription(String id) throws ConfigException {
        return this.getJ2eeApplication(id).getDescription();
    }

    private J2eeApplication getJ2eeApplication(String appId) throws ConfigException {
        J2eeApplication app = ((Applications)this.configBean).getJ2eeApplicationByName(appId);
        if (app == null) {
            throw new ConfigException(Localizer.getValue(ExceptionType.APP_NOT_EXIST));
        }
        return app;
    }

    public void setDescription(String id, String desc) throws ConfigException {
        this.getJ2eeApplication(id).setDescription(desc);
    }

    public String getVirtualServersByAppName(String appName) throws ConfigException {
        return ServerBeansFactory.getVirtualServersByAppName(this.configContext, appName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map getRegisteredDescriptors() {
        if (apps != null) return apps;
        Class<AppsManager> clazz = AppsManager.class;
        synchronized (AppsManager.class) {
            if (apps != null) return apps;
            apps = new HashMap();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return apps;
        }
    }
}

