/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.distributedtx;

import com.sun.enterprise.Switch;
import com.sun.enterprise.distributedtx.J2EETransaction;
import com.sun.enterprise.util.i18n.StringManager;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionSynchronizationRegistry;

public class TransactionSynchronizationRegistryImpl
implements TransactionSynchronizationRegistry {
    private static TransactionSynchronizationRegistryImpl _instance = new TransactionSynchronizationRegistryImpl();
    private static StringManager sm = StringManager.getManager(TransactionSynchronizationRegistryImpl.class);

    public Object getTransactionKey() {
        try {
            return Switch.getSwitch().getTransactionManager().getTransaction();
        }
        catch (SystemException ex) {
            return null;
        }
    }

    public void putResource(Object key, Object value) {
        try {
            J2EETransaction tran = (J2EETransaction)Switch.getSwitch().getTransactionManager().getTransaction();
            if (tran == null) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
            }
            tran.putUserResource(key, value);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    public Object getResource(Object key) {
        try {
            J2EETransaction tran = (J2EETransaction)Switch.getSwitch().getTransactionManager().getTransaction();
            if (tran == null) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
            }
            return tran.getUserResource(key);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    public void registerInterposedSynchronization(Synchronization sync) {
        try {
            J2EETransaction tran = (J2EETransaction)Switch.getSwitch().getTransactionManager().getTransaction();
            if (tran == null) {
                throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
            }
            tran.registerInterposedSynchronization(sync);
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    public int getTransactionStatus() {
        try {
            return Switch.getSwitch().getTransactionManager().getStatus();
        }
        catch (SystemException ex) {
            return 6;
        }
    }

    public void setRollbackOnly() {
        try {
            Switch.getSwitch().getTransactionManager().setRollbackOnly();
        }
        catch (SystemException ex) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
    }

    public boolean getRollbackOnly() {
        int status = this.getTransactionStatus();
        if (status == 6) {
            throw new IllegalStateException(sm.getString("enterprise_distributedtx.no_transaction"));
        }
        return status == 1 || status == 9;
    }

    public static TransactionSynchronizationRegistry getInstance() {
        return _instance;
    }
}

