/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.FileData;
import com.sun.enterprise.diagnostics.collect.ProcessExecutor;
import com.sun.enterprise.diagnostics.collect.ProcessExecutorException;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WindowsSystemInfoCollector
implements Collector {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");
    private static final String MEMORY_INFO_CMD = "mem";
    private static final String IP_ADDRESS_INFO_CMD = "ipconfig";
    private static final String HOST_NAME_CMD = "hostname";
    private static final String OS_INFO_CMD = "ver";
    private String destFolder = null;

    public WindowsSystemInfoCollector(String destFolder) {
        this.destFolder = destFolder;
    }

    public Data capture() {
        FileData data = null;
        String outputFileName = this.destFolder + File.separator + Defaults.SYSTEM_INFO_FILE;
        String ALL_CMDS = "(echo HOSTNAME & hostname & echo OS INFO & ver & echo MEMORY INFO & mem & echo IP ADDRESS & ipconfig) >> " + outputFileName;
        String[] cmd = new String[]{"cmd.exe", "/C", ALL_CMDS};
        ProcessExecutor executor = new ProcessExecutor(cmd, 0L);
        try {
            executor.execute();
            File outputFile = new File(outputFileName);
            data = new FileData(outputFile.getName(), "system Info");
        }
        catch (ProcessExecutorException pee) {
            logger.log(Level.WARNING, "Exception while capturing system info : " + pee.getMessage());
        }
        return data;
    }
}

