/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.phasing.ApplicationConfigHelper;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.deployment.phasing.DeploymentTarget;
import com.sun.enterprise.deployment.phasing.DeploymentTargetException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AssociationPhase
extends DeploymentPhase {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(AssociationPhase.class);

    public AssociationPhase(DeploymentContext deploymentCtx) {
        this.deploymentCtx = deploymentCtx;
        this.name = "Associate";
    }

    public void prePhase(DeploymentPhaseContext phaseCtx) {
        DeploymentRequest req = phaseCtx.getDeploymentRequest();
        DeploymentStatus status = phaseCtx.getDeploymentStatus();
        DeploymentTarget target = (DeploymentTarget)req.getTarget();
        try {
            String virtualServers = (String)req.getOptionalAttributes().get("virtual-servers");
            String contextRootInConflict = ApplicationConfigHelper.checkContextRootUniqueness(DeploymentServiceUtils.getConfigContext(), req.getName(), req.getTarget().getName(), virtualServers);
            if (contextRootInConflict != null) {
                throw new IASDeploymentException(localStrings.getString("duplicate_context_root", contextRootInConflict, req.getName(), req.getTarget().getName()));
            }
            if (DeploymentServiceUtils.isDirectoryDeployed(req.getName(), req.getType())) {
                if (target != null && ServerHelper.isAServer(this.deploymentCtx.getConfigContext(), target.getTarget().getName()) && ServerHelper.isDAS(this.deploymentCtx.getConfigContext(), target.getTarget().getName())) {
                    return;
                }
                throw new IASDeploymentException(localStrings.getString("dir_deploy_not_support"));
            }
        }
        catch (Throwable t) {
            status.setStageStatus(0);
            status.setStageException(t);
            status.setStageStatusMessage(t.getMessage());
        }
    }

    public void runPhase(DeploymentPhaseContext phaseCtx) {
        block3: {
            try {
                DeploymentRequest req = phaseCtx.getDeploymentRequest();
                DeploymentTarget target = (DeploymentTarget)req.getTarget();
                if (target == null) {
                    String msg = localStrings.getString("enterprise.deployment.phasing.association.targetnotspecified");
                    sLogger.log(Level.FINEST, msg);
                    phaseCtx.getDeploymentStatus().setStageStatus(1);
                    return;
                }
                this.prePhaseNotify(this.getPrePhaseEvent(req));
                String virtualServers = (String)req.getOptionalAttributes().get("virtual-servers");
                target.addAppReference(req.getName(), req.isStartOnDeploy(), virtualServers);
                this.postPhaseNotify(this.getPostPhaseEvent(req));
                this.sendAssociateEvent(req);
                phaseCtx.getDeploymentStatus().setStageStatus(2);
            }
            catch (DeploymentTargetException dte) {
                phaseCtx.getDeploymentStatus().setStageStatus(0);
                phaseCtx.getDeploymentStatus().setStageException(dte.getCause());
                if (dte.getCause() == null) break block3;
                phaseCtx.getDeploymentStatus().setStageStatusMessage(dte.getCause().getMessage());
            }
        }
    }

    private DeploymentEvent getPrePhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(11, new DeploymentEventInfo(req));
    }

    private DeploymentEvent getPostPhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(12, new DeploymentEventInfo(req));
    }

    private void sendAssociateEvent(DeploymentRequest req) throws DeploymentTargetException {
        try {
            DeploymentTarget target = (DeploymentTarget)req.getTarget();
            String moduleType = req.isApplication() ? null : DeploymentServiceUtils.getModuleTypeString(req.getType());
            int eventType = 11;
            String appName = req.getName();
            String targetName = target.getTarget().getName();
            boolean success = DeploymentServiceUtils.multicastEvent(eventType, appName, moduleType, false, true, targetName);
            sLogger.log(Level.FINE, "sendAssociateEvent: success=" + success);
        }
        catch (Throwable t) {
            DeploymentTargetException dte = new DeploymentTargetException(t.getMessage());
            dte.initCause(t);
            throw dte;
        }
    }
}

