/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.ejb.codegen.IASEJBCTimes;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.backend.Deployer;
import com.sun.enterprise.deployment.backend.DeploymentCommand;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentEventManager;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.DeploymentUtils;
import com.sun.enterprise.deployment.backend.EJBCompiler;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchiveFactory;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.loader.EJBClassPathUtils;
import com.sun.enterprise.tools.verifier.AppVerifier;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileSource;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipItem;
import com.sun.enterprise.webservice.WsUtil;
import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public abstract class ModuleDeployer
extends Deployer {
    protected BaseManager modulesMgr = null;
    protected String moduleName = null;
    protected File moduleDir = null;
    protected File stubsDir = null;
    protected File jspDir = null;
    protected File xmlDir = null;
    protected File jwsDir = null;
    protected File originalModuleDir = null;
    protected String originalContextRoot = null;
    protected File oldModuleDir = null;
    protected File oldStubsDir = null;
    protected File oldJSPDir = null;
    protected File oldXMLDir = null;
    protected File oldJWSDir = null;
    protected ModuleEnvironment moduleEnv = null;
    protected String oldRegisteredLocation = null;
    protected boolean isMaybeCMPDropTables = false;
    private boolean wasReg = false;
    private boolean wasRegisteredThisSession = false;
    private boolean shouldRollback = false;
    private boolean moduleDirWasRenamed = false;
    private static StringManager localStrings = StringManager.getManager(ModuleDeployer.class);

    protected abstract BaseManager createConfigManager(InstanceEnvironment var1, ModuleEnvironment var2) throws IASDeploymentException, ConfigException;

    protected abstract void preDeploy() throws IASDeploymentException;

    protected abstract void deploy() throws IASDeploymentException, ConfigException;

    protected abstract void preRedeploy() throws IASDeploymentException, ConfigException;

    protected ModuleDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    protected boolean needsStubs() {
        return false;
    }

    protected boolean needsJSPs() {
        return false;
    }

    protected final File getModuleDir() {
        return this.moduleDir;
    }

    public void doRequest() throws IASDeploymentException {
        this.doRequestPrepare();
        this.doRequestFinish();
    }

    public void doRequestPrepare() throws IASDeploymentException {
        try {
            this.begin();
        }
        catch (Exception e) {
            if (this.shouldRollback) {
                this.rollback();
            }
            String msg = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
            this.logger.log(Level.WARNING, msg, e);
            throw new IASDeploymentException(msg, e);
        }
    }

    public void doRequestFinish() throws IASDeploymentException {
        try {
            try {
                if (this.request.isDeploy()) {
                    DeploymentStatus J2EECPhaseStatus = this.request.getCurrentDeploymentStatus();
                    this.beginFinish();
                    this.preDeploy();
                    DeploymentStatus runEJBCStatus = new DeploymentStatus(J2EECPhaseStatus);
                    this.request.setCurrentDeploymentStatus(runEJBCStatus);
                    this.deploy();
                    this.register();
                    DeploymentStatus postDeployStatus = new DeploymentStatus(J2EECPhaseStatus);
                    this.request.setCurrentDeploymentStatus(postDeployStatus);
                    this.postDeploy();
                    this.generatePolicy();
                } else if (this.request.isReDeploy()) {
                    DeploymentStatus J2EECPhaseStatus = this.request.getCurrentDeploymentStatus();
                    this.beginFinish();
                    this.preRedeploy();
                    DeploymentStatus runEJBCStatus = new DeploymentStatus(J2EECPhaseStatus);
                    this.request.setCurrentDeploymentStatus(runEJBCStatus);
                    this.redeploy();
                    this.register();
                    DeploymentStatus postDeployStatus = new DeploymentStatus(J2EECPhaseStatus);
                    this.request.setCurrentDeploymentStatus(postDeployStatus);
                    this.postRedeploy();
                    this.generatePolicy();
                } else if (this.request.isUnDeploy()) {
                    this.beginFinish();
                    this.preundeploy();
                    this.undeploy();
                    this.removePolicy();
                } else {
                    String msg = localStrings.getString("enterprise.deployment.backend.unknown_deployment_command");
                    throw new IASDeploymentException(msg);
                }
                Object var5_10 = null;
            }
            catch (Exception e) {
                if (this.shouldRollback) {
                    this.rollback();
                }
                String msg = localStrings.getString("enterprise.deployment.backend.dorequest_exception");
                this.logger.log(Level.FINE, msg, e);
                if (e instanceof IASDeploymentException) {
                    throw (IASDeploymentException)e;
                }
                throw new IASDeploymentException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            this.finish();
            throw throwable;
        }
        this.finish();
    }

    protected final void begin() throws IASDeploymentException {
        super.begin();
        InstanceEnvironment instanceEnv = this.getInstanceEnv();
        this.moduleEnv = this.request.getModuleEnv();
        this.moduleName = this.request.getName();
        if (this.moduleEnv == null) {
            String msg = localStrings.getString("enterprise.deployment.backend.null_moduleenvironment");
            throw new IASDeploymentException(msg);
        }
        try {
            this.moduleEnv.verify();
            this.modulesMgr = this.createConfigManager(instanceEnv, this.moduleEnv);
            this.setDeployCommand();
            if (this.request.isReDeploy()) {
                this.originalModuleDir = new File(DeploymentServiceUtils.getLocation(this.moduleName, this.request.getType()));
                this.unregister();
                this.removePolicy();
            }
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
        this.shouldRollback = true;
    }

    private void beginFinish() throws IASDeploymentException {
        this.setDirs();
    }

    private void setDirs() throws IASDeploymentException {
        assert (this.modulesMgr != null);
        assert (this.moduleName != null);
        assert (this.moduleEnv != null);
        if (this.request.isDeploy()) {
            this.setDirsDeploy();
        } else if (this.request.isReDeploy()) {
            this.setDirsReDeploy();
        } else if (this.request.isUnDeploy()) {
            this.setDirsUnDeploy();
        } else {
            String msg = localStrings.getString("enterprise.deployment.backend.deployment_type_error");
            throw new IASDeploymentException(msg);
        }
        this.request.setDeployedDirectory(this.moduleDir);
        this.request.setJSPDirectory(this.jspDir);
        this.request.setStubsDirectory(this.stubsDir);
        this.request.setGeneratedXMLDirectory(this.xmlDir);
    }

    protected List getModuleClasspath(Archivist archivist, AbstractArchive archive) throws IASDeploymentException {
        try {
            String location = this.request.getDeployedDirectory().getAbsolutePath();
            return EJBClassPathUtils.getModuleClasspath(this.request.getName(), location, this.getManager());
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    private void setDirsDeploy() throws IASDeploymentException {
        if (this.isRegistered()) {
            String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
            throw new IASDeploymentException(msg);
        }
        this.xmlDir = new File(this.moduleEnv.getModuleGeneratedXMLPath());
        this.jwsDir = new File(this.moduleEnv.getJavaWebStartPath());
        this.stubsDir = this.needsStubs() ? new File(this.moduleEnv.getModuleStubPath()) : null;
        if (this.needsJSPs()) {
            assert (this.modulesMgr instanceof WebModulesManager);
            this.jspDir = new File(this.moduleEnv.getModuleJSPPath());
        }
        if (this.isArchive()) {
            File parent = new File(this.getInstanceEnv().getModuleRepositoryPath());
            this.moduleDir = new File(parent, this.moduleName);
            this.moduleDir.mkdirs();
        } else if (this.isDirectory()) {
            FileSource fileSource = this.request.getFileSource();
            if (fileSource == null || !fileSource.exists()) {
                String msg = localStrings.getString("enterprise.deployment.backend.file_source_does_not_exist", fileSource);
                throw new IASDeploymentException(msg);
            }
            this.moduleDir = fileSource.getFile();
            if (!FileUtils.safeIsDirectory(this.moduleDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.deployment_directory_does_not_exist", this.moduleDir.getPath());
                throw new IASDeploymentException(msg);
            }
        } else {
            String msg = localStrings.getString("enterprise.deployment.backend.deployment_not_dir_or_archive");
            throw new IASDeploymentException(msg);
        }
    }

    protected Application loadDescriptors() throws IASDeploymentException {
        Application app = super.loadDescriptors();
        new WsUtil().genWSInfo(app, this.request);
        return app;
    }

    private void setDirsUnDeploy() throws IASDeploymentException {
        try {
            if (!this.isRegistered()) {
                String msg = localStrings.getString("enterprise.deployment.backend.undeploy_error_module_not_registered");
                throw new IASDeploymentException(msg);
            }
            this.moduleDir = new File(DeploymentServiceUtils.getLocation(this.moduleName, this.request.getType()));
            this.xmlDir = new File(this.modulesMgr.getGeneratedXMLLocation(this.moduleName));
            this.jwsDir = new File(this.moduleEnv.getJavaWebStartPath());
            this.stubsDir = null;
            this.jspDir = null;
            if (this.needsStubs()) {
                this.stubsDir = new File(this.modulesMgr.getStubLocation(this.moduleName));
            }
            if (this.needsJSPs()) {
                assert (this.modulesMgr instanceof WebModulesManager);
                WebModulesManager mgr = (WebModulesManager)this.modulesMgr;
                this.jspDir = new File(mgr.getJSPLocation(this.moduleName));
            }
        }
        catch (Exception e) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_getting_module_directory", e);
            throw new IASDeploymentException(msg);
        }
    }

    private void setDirsReDeploy() throws IASDeploymentException {
        String msg;
        if (!this.wasReg) {
            String msg2 = localStrings.getString("enterprise.deployment.backend.redeploy_error_module_not_registered");
            throw new IASDeploymentException(msg2);
        }
        this.xmlDir = new File(this.modulesMgr.getGeneratedXMLLocation(this.moduleName));
        this.jwsDir = new File(this.moduleEnv.getJavaWebStartPath());
        this.stubsDir = null;
        this.jspDir = null;
        if (this.needsStubs()) {
            this.stubsDir = new File(this.modulesMgr.getStubLocation(this.moduleName));
        }
        if (this.needsJSPs()) {
            assert (this.modulesMgr instanceof WebModulesManager);
            WebModulesManager mgr = (WebModulesManager)this.modulesMgr;
            this.jspDir = new File(mgr.getJSPLocation(this.moduleName));
        }
        if (this.isArchive()) {
            if (!FileUtils.safeIsDirectory(this.originalModuleDir)) {
                msg = localStrings.getString("enterprise.deployment.backend.modulesmanager_error_getting_module_location", this.moduleName);
                throw new IASDeploymentException(msg);
            }
            this.moduleDir = this.originalModuleDir;
            this.oldModuleDir = new File(this.moduleDir.getAbsolutePath() + "_old");
            FileUtils.whack(this.oldModuleDir);
            this.moduleDirWasRenamed = FileUtils.renameFile(this.moduleDir, this.oldModuleDir);
            if (!this.moduleDirWasRenamed) {
                msg = localStrings.getString("enterprise.deployment.backend.directory_rename_error", this.moduleDir.getAbsolutePath(), this.oldModuleDir.getAbsolutePath());
                throw new IASDeploymentException(msg);
            }
        } else if (this.isDirectory()) {
            FileSource fileSource = this.request.getFileSource();
            if (!fileSource.exists()) {
                String msg3 = localStrings.getString("enterprise.deployment.backend.file_source_does_not_exist", fileSource);
                throw new IASDeploymentException(msg3);
            }
            assert (fileSource.isDirectory());
            this.moduleDir = fileSource.getFile();
            this.oldModuleDir = new File(this.moduleEnv.getModuleBackupPath());
            if (!FileUtils.safeIsDirectory(this.oldModuleDir)) {
                this.oldModuleDir = null;
            }
        } else {
            msg = localStrings.getString("enterprise.deployment.backend.redeployment_not_dir_or_archive");
            throw new IASDeploymentException(msg);
        }
        this.moduleDir.mkdirs();
    }

    public void cleanup_internal() {
        try {
            if (this.request.isUnDeploy()) {
                if (this.isMaybeCMPDropTables) {
                    this.dropTables();
                }
                this.liquidate();
            } else if (this.request.isReDeploy() && this.isArchive() && this.oldModuleDir != null) {
                FileUtils.whack(this.oldModuleDir);
            }
        }
        catch (Exception e) {
            this.logger.warning("Exception caught and ignored in cleanup_internal()");
        }
    }

    protected void liquidate() throws IASDeploymentException, ConfigException {
        assert (!this.request.isReDeploy());
        assert (this.moduleDir != null);
        boolean shouldDeleteModuleFiles = false;
        if (this.request.isDeploy() && this.isArchive()) {
            shouldDeleteModuleFiles = true;
        } else if (this.request.isUnDeploy() && !DeploymentServiceUtils.isDirectoryDeployed(this.request.getName(), this.request.getType()) && !this.request.isReload()) {
            shouldDeleteModuleFiles = true;
        }
        if (shouldDeleteModuleFiles) {
            if (FileUtils.safeIsDirectory(this.moduleDir)) {
                FileUtils.whack(this.moduleDir);
                this.logger.fine("Deleted module Directory: " + this.moduleDir.getPath());
            } else {
                this.logger.warning("Can't delete module Directory -- it isn't a directory: " + FileUtils.safeGetCanonicalPath(this.moduleDir));
            }
        } else {
            this.logger.fine("Did NOT delete module Directory (Directory-Deployment): " + this.moduleDir.getPath());
        }
        this.DeleteOrKeepFailedStubs(this.stubsDir);
        if (FileUtils.safeIsDirectory(this.jspDir)) {
            FileUtils.whack(this.jspDir);
        }
        if (FileUtils.safeIsDirectory(this.xmlDir)) {
            FileUtils.whack(this.xmlDir);
        }
        if (FileUtils.safeIsDirectory(this.jwsDir)) {
            FileUtils.whack(this.jwsDir);
        }
    }

    protected void preundeploy() throws IASDeploymentException, ConfigException {
        if (this.getRequest().isMaybeCMPDropTables()) {
            this.isMaybeCMPDropTables = true;
        }
    }

    private void undeploy() throws IASDeploymentException, ConfigException {
        if (!this.isRegistered()) {
            String msg = localStrings.getString("enterprise.deployment.backend.undeploy_error_module_not_registered");
            throw new IASDeploymentException(msg);
        }
        try {
            this.unregister();
        }
        catch (ConfigException e) {
            String msg = localStrings.getString("enterprise.deployment.backend.config_exception_on_remove", this.moduleName, e);
            throw new IASDeploymentException(msg, e);
        }
    }

    private void rollbackUndeploy() throws ConfigException {
    }

    protected void postDeploy() throws IASDeploymentException, ConfigException {
        String resourceType;
        Properties optionalAttributes = this.request.getOptionalAttributes();
        if (optionalAttributes == null) {
            optionalAttributes = new Properties();
        }
        if ((resourceType = this.getResourceType(this.moduleDir)) != null) {
            optionalAttributes.setProperty("object-type", resourceType);
        }
        this.handlePostDeployEvent();
    }

    protected void handlePostDeployEvent() throws IASDeploymentException {
        DeploymentEventInfo info = this.getEventInfo();
        DeploymentEvent ev = new DeploymentEvent(2, info);
        DeploymentEventManager.notifyDeploymentEvent(ev);
    }

    protected DeploymentEventInfo getEventInfo() throws IASDeploymentException {
        return new DeploymentEventInfo(this.moduleDir, this.stubsDir, this.oldStubsDir, this.request.getDescriptor(), this.getRequest());
    }

    protected final void rollbackDeploy() throws IASDeploymentException {
        try {
            if (this.wasRegisteredThisSession) {
                this.unregister();
            }
            this.liquidate();
        }
        catch (ConfigException configException) {
            // empty catch block
        }
    }

    protected final void redeploy() throws IASDeploymentException, ConfigException {
        this.deploy();
    }

    private void rollback() {
        try {
            if (this.request.isDeploy()) {
                this.rollbackDeploy();
            } else if (this.request.isReDeploy()) {
                if (this.request.isArchive()) {
                    this.rollbackRedeploy();
                } else {
                    this.request.setReRegisterOnFailure(false);
                }
            } else if (this.request.isUnDeploy()) {
                this.rollbackUndeploy();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void register() throws IASDeploymentException, ConfigException {
        this.modulesMgr.registerDescriptor(this.moduleName, this.request.getDescriptor());
        this.wasRegisteredThisSession = true;
    }

    protected void liquidateModuleDirAndStubsDirIfTheyHappenToExist() throws IASDeploymentException {
        if (this.request.isArchive() && FileUtils.safeIsDirectory(this.moduleDir)) {
            FileUtils.whack(this.moduleDir);
            if (FileUtils.safeIsDirectory(this.moduleDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_dir_is_locked", "Module", this.moduleDir.getAbsolutePath());
                throw new IASDeploymentException(msg);
            }
        }
        if (FileUtils.safeIsDirectory(this.stubsDir)) {
            FileUtils.whack(this.stubsDir);
            if (FileUtils.safeIsDirectory(this.stubsDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_dir_is_locked", "Stubs", this.stubsDir.getAbsolutePath());
                throw new IASDeploymentException(msg);
            }
        }
        if (FileUtils.safeIsDirectory(this.jspDir)) {
            FileUtils.whack(this.jspDir);
            if (FileUtils.safeIsDirectory(this.jspDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_dir_is_locked", "JSP", this.jspDir.getAbsolutePath());
                throw new IASDeploymentException(msg);
            }
        }
        if (FileUtils.safeIsDirectory(this.xmlDir)) {
            FileUtils.whack(this.xmlDir);
            if (FileUtils.safeIsDirectory(this.xmlDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_dir_is_locked", "XML", this.xmlDir.getAbsolutePath());
                throw new IASDeploymentException(msg);
            }
        }
        if (FileUtils.safeIsDirectory(this.jwsDir)) {
            FileUtils.whack(this.jwsDir);
            if (FileUtils.safeIsDirectory(this.jwsDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_dir_is_locked", "JWS", this.jwsDir.getAbsolutePath());
                throw new IASDeploymentException(msg);
            }
        }
    }

    protected void setOldDirs() throws IASDeploymentException {
        assert (this.moduleDir != null);
        assert (this.moduleEnv != null);
        assert (this.request.isReDeploy());
        if (this.needsStubs() && this.stubsDir != null && this.stubsDir.exists() && this.stubsDir.isDirectory()) {
            this.oldStubsDir = new File(this.stubsDir.getPath() + "_old");
            if (this.oldStubsDir.exists()) {
                FileUtils.whack(this.oldStubsDir);
            }
            if (!FileUtils.renameFile(this.stubsDir, this.oldStubsDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.directory_rename_error", this.stubsDir.getPath(), this.oldStubsDir.getPath());
                throw new IASDeploymentException(msg);
            }
        }
        if (this.needsJSPs() && FileUtils.safeIsDirectory(this.jspDir)) {
            this.oldJSPDir = new File(this.jspDir.getPath() + "_old");
            if (this.oldJSPDir.exists()) {
                FileUtils.whack(this.oldJSPDir);
            }
            if (!FileUtils.renameFile(this.jspDir, this.oldJSPDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.directory_rename_error", this.jspDir.getPath(), this.oldJSPDir.getPath());
                throw new IASDeploymentException(msg);
            }
        }
        if (FileUtils.safeIsDirectory(this.xmlDir)) {
            this.oldXMLDir = new File(this.xmlDir.getPath() + "_old");
            if (this.oldXMLDir.exists()) {
                FileUtils.whack(this.oldXMLDir);
            }
            if (!FileUtils.renameFile(this.xmlDir, this.oldXMLDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.directory_rename_error", this.xmlDir.getPath(), this.oldXMLDir.getPath());
                throw new IASDeploymentException(msg);
            }
        }
        if (FileUtils.safeIsDirectory(this.jwsDir)) {
            if (this.jwsDir.list().length > 0) {
                DeploymentStatus jwsStatus = new DeploymentStatus(this.request.getCurrentDeploymentStatus());
                jwsStatus.setStageStatus(1);
                jwsStatus.setStageStatusMessage(localStrings.getString("enterprise.deployment.backend.jws_redeploy", this.jwsDir.getPath()));
            }
            this.oldJWSDir = new File(this.jwsDir.getPath() + "_old");
            if (this.oldJWSDir.exists()) {
                FileUtils.whack(this.oldJWSDir);
            }
            if (!FileUtils.renameFile(this.jwsDir, this.oldJWSDir)) {
                String msg = localStrings.getString("enterprise.deployment.backend.directory_rename_error", this.jwsDir.getPath(), this.oldJWSDir.getPath());
                throw new IASDeploymentException(msg);
            }
        }
    }

    protected boolean isRegistered() throws IASDeploymentException {
        return DeploymentServiceUtils.isRegistered(this.moduleName, this.request.getType());
    }

    protected boolean isSystem() throws IASDeploymentException {
        try {
            boolean guardSystemApp;
            boolean isSystem = DeploymentServiceUtils.isSystem(this.moduleName, this.request.getType());
            boolean bl = guardSystemApp = Boolean.valueOf(System.getProperty("com.sun.aas.deployment.AllowSysAppDeployment", "false")) == false;
            return isSystem && guardSystemApp;
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected void setShared(boolean what) throws ConfigException {
    }

    protected void unregister() throws ConfigException {
        this.modulesMgr.unregisterDescriptor(this.moduleName);
    }

    protected void postRedeploy() throws IASDeploymentException, ConfigException {
        this.handlePostDeployEvent();
        if (FileUtils.safeIsDirectory(this.oldStubsDir)) {
            FileUtils.whack(this.oldStubsDir);
        }
        if (FileUtils.safeIsDirectory(this.oldJSPDir)) {
            FileUtils.whack(this.oldJSPDir);
        }
        if (FileUtils.safeIsDirectory(this.oldXMLDir)) {
            FileUtils.whack(this.oldXMLDir);
        }
        if (FileUtils.safeIsDirectory(this.oldJWSDir)) {
            FileUtils.whack(this.oldJWSDir);
        }
    }

    protected void rollbackRedeploy() throws IASDeploymentException {
        if (this.isArchive() && this.wasModuleDirRenamed()) {
            if (FileUtils.safeIsDirectory(this.moduleDir)) {
                FileUtils.whack(this.moduleDir);
            }
            if (FileUtils.safeIsDirectory(this.oldModuleDir)) {
                this.oldModuleDir.renameTo(this.moduleDir);
            }
        }
        if (FileUtils.safeIsDirectory(this.oldStubsDir)) {
            this.DeleteOrKeepFailedStubs(this.stubsDir);
            this.oldStubsDir.renameTo(this.stubsDir);
        }
        if (FileUtils.safeIsDirectory(this.jspDir)) {
            FileUtils.whack(this.jspDir);
        }
        if (FileUtils.safeIsDirectory(this.oldJSPDir)) {
            this.oldJSPDir.renameTo(this.jspDir);
        }
        if (FileUtils.safeIsDirectory(this.xmlDir)) {
            FileUtils.whack(this.xmlDir);
        }
        if (FileUtils.safeIsDirectory(this.oldXMLDir)) {
            this.oldJSPDir.renameTo(this.xmlDir);
        }
        if (FileUtils.safeIsDirectory(this.oldJWSDir)) {
            this.oldJWSDir.renameTo(this.jwsDir);
        }
        try {
            this.register();
        }
        catch (Exception e) {
            throw new IASDeploymentException(e);
        }
    }

    protected final boolean wasModuleDirRenamed() {
        return this.moduleDirWasRenamed;
    }

    protected void runVerifier() throws IASDeploymentException {
        if (this.request.isVerifying()) {
            try {
                String archive = this.request.getDeployedDirectory().getCanonicalPath();
                File jspOutDir = this.request.getPrecompileJSP() ? this.jspDir : null;
                new AppVerifier().verify(this.request.getDescriptor(), new FileArchiveFactory().openArchive(archive), this.request.getCompleteClasspath(), jspOutDir);
            }
            catch (Exception e) {
                String msg = localStrings.getString("enterprise.deployment.backend.verifier_error");
                throw new IASDeploymentException(msg);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDeployCommand() throws IASDeploymentException {
        boolean isReg = this.isRegistered();
        boolean isSystem = false;
        this.wasReg = isReg;
        if (isReg) {
            isSystem = this.isSystem();
        }
        if (this.request.isUnDeploy()) {
            if (!isReg) {
                String msg = localStrings.getString("enterprise.deployment.backend.undeploy_error_module_not_registered");
                throw new IASDeploymentException(msg);
            }
            if (!isSystem) return;
            String msg = localStrings.getString("enterprise.deployment.backend.undeploy_error_module_is_a_system_resource");
            throw new IASDeploymentException(msg);
        }
        if (!this.request.isDeploy()) return;
        if (!isReg) {
            this.checkRegisteredAnywhereElse(this.moduleName);
            return;
        }
        if (isSystem) {
            String msg = localStrings.getString("enterprise.deployment.backend.redeploy_error_module_is_a_system_resource");
            throw new IASDeploymentException(msg);
        }
        if (this.request.isForced()) {
            this.request.setCommand(DeploymentCommand.REDEPLOY);
            return;
        }
        String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
        throw new IASDeploymentException(msg);
    }

    protected ZipItem[] runEJBC() throws IASDeploymentException {
        ZipItem[] clientStubs = null;
        try {
            IASEJBCTimes timing = new IASEJBCTimes();
            EJBCompiler compiler = new EJBCompiler(this.moduleName, this.moduleDir, this.oldModuleDir, this.stubsDir, this.oldStubsDir, this.getManager(), this.request, timing);
            clientStubs = compiler.compile();
            this.addEJBCTime(timing);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "enterprise.deployment_ejbc_error", e);
            String msg = localStrings.getString("enterprise.deployment.backend.ejbc_error");
            throw new IASDeploymentException(msg, e);
        }
        return clientStubs;
    }

    protected BaseManager getManager() {
        return this.modulesMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropTables() {
        assert (this.isMaybeCMPDropTables);
        try {
            Application moduleDD;
            block6: {
                if (FileUtils.safeIsDirectory(this.xmlDir)) {
                    moduleDD = DeploymentUtils.getModuleDescriptor(this.xmlDir.getAbsolutePath());
                    FileArchive archive = new FileArchive();
                    archive.open(this.moduleDir.getAbsolutePath());
                    try {
                        ApplicationArchivist.readPersistenceDeploymentDescriptorsRecursively(archive, moduleDD);
                        Object var4_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        archive.close();
                        throw throwable;
                    }
                    archive.close();
                    {
                        break block6;
                    }
                }
                moduleDD = DeploymentUtils.getModuleDescriptor(this.moduleDir.getAbsolutePath());
            }
            moduleDD.setRegistrationName(this.moduleName);
            DeploymentEventInfo info = new DeploymentEventInfo(this.moduleDir, this.stubsDir, this.oldStubsDir, moduleDD, this.request);
            DeploymentEvent ev = new DeploymentEvent(3, info);
            DeploymentEventManager.notifyDeploymentEvent(ev);
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "enterprise.deployment_pre_undeploy_event_error", t);
        }
    }

    public void removePolicy() throws IASDeploymentException {
    }
}

