/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.appclient.jws.Content;
import com.sun.enterprise.appclient.jws.DynamicContent;
import com.sun.enterprise.appclient.jws.StaticContent;
import com.sun.enterprise.appclient.jws.Util;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContentOrigin {
    protected static String lineSep = System.getProperty("line.separator");
    protected Map<String, Content> pathToContent = new HashMap<String, Content>();
    private boolean adhocPathRegistered = false;

    public abstract boolean isEnabled();

    protected Content getContent(String contentKey) {
        return this.pathToContent.get(contentKey);
    }

    protected DynamicContent addDynamicContent(String path, String template, Properties tokenValues, String mimeType) throws IOException {
        return this.addDynamicContent(path, template, tokenValues, mimeType, false);
    }

    protected DynamicContent addDynamicContent(String path, String template, Properties tokenValues, String mimeType, boolean requiresElevatedPrivs) {
        String docText = Util.replaceTokens(template, tokenValues);
        String contentKey = this.getContentKeyPrefix() + path;
        DynamicContent result = new DynamicContent(this, contentKey, path, docText, mimeType, requiresElevatedPrivs);
        this.pathToContent.put(result.getContentKey(), result);
        return result;
    }

    protected DynamicContent addDynamicContent(DynamicContent content) {
        this.pathToContent.put(content.getContentKey(), content);
        return content;
    }

    protected StaticContent addStaticContent(String path, URI installRootURI, File file) throws URISyntaxException {
        String contentKey = this.getContentKeyPrefix() + path;
        StaticContent result = new StaticContent(this, contentKey, path, file, installRootURI, false);
        return this.addStaticContent(result);
    }

    protected StaticContent addStaticContent(StaticContent content) {
        this.pathToContent.put(content.getContentKey(), content);
        return content;
    }

    protected abstract String getContentKeyPrefix();

    public Collection<Content> getContents() {
        return this.pathToContent.values();
    }

    void adhocPathRegistered() {
        this.adhocPathRegistered = true;
    }

    boolean isAdhocPathRegistered() {
        return this.adhocPathRegistered;
    }

    public String toLongString() {
        return this.toString() + this.pathToContent.toString();
    }
}

