/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.AdminContext;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.server.core.mbean.config.AdminBase;
import com.sun.enterprise.admin.server.core.mbean.config.naming.ConfigMBeanNamingInfo;
import com.sun.enterprise.admin.server.core.mbean.meta.MBeanEasyConfig;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ConfigMBeanBase
extends AdminBase {
    public static final Logger sLogger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String MSG_BASE_GET_ATTRIBUTE = "mbean.config.base_get_attribute";
    private static final String MSG_BASE_SET_ATTRIBUTE = "mbean.config.base_set_attribute";
    private static final String MSG_BASE_GOT_ATTRIBUTE = "mbean.config.base_got_attribute";
    private static final String MSG_BASE_GET_PROPERTY = "mbean.config.base_get_property";
    private static final String MSG_BASE_SET_PROPERTY = "mbean.config.base_set_property";
    private static final String MSG_BASE_GET_DEF_ATTR_VALUE = "mbean.config.get_def_attr_value";
    private static final String MSG_GET_CONFBEANBYXPATH = "mbean.config.get_confbeanbyxpath";
    private static final String MSG_LOG_CONF_CTX = "mbean.config.log_config_id";
    public static final char ATTRIBUTE_CHAR = '@';
    public static final char ALLOWS_EMPTY_CHAR = '@';
    public static final String ATTRIBUTE = "@";
    public static final String E_ATTRIBUTE = "@@";
    public static final String PROPERTY = "element-property/@";
    public static final String E_PROPERTY = "element-property/@@";
    public static final String ELEMENT_CONTENT = "";
    public static final String PSEUDO_ATTR_DESCRIPTION = "description";
    private AdminContext m_AdminContext;
    private ConfigContext m_configContext;
    private String m_BasePath;
    private Hashtable m_Attrs;
    private MBeanInfo m_MBeanInfo;
    private String m_ServerInstanceName;
    private ConfigMBeanNamingInfo m_MBeanNamingInfo;
    private static StringManager localStrings = StringManager.getManager(ConfigMBeanBase.class);

    public void initialize(ConfigMBeanNamingInfo namingInfo) throws MBeanConfigException {
        ConfigContext configContext;
        String instanceName = namingInfo.getServerInstanceName();
        if (this.m_AdminContext != null) {
            configContext = this.m_AdminContext.getAdminConfigContext();
        } else {
            try {
                InstanceEnvironment instanceEnvironment = new InstanceEnvironment(instanceName);
                String fileUrl = instanceEnvironment.getConfigFilePath();
                configContext = ConfigFactory.createConfigContext(fileUrl);
            }
            catch (ConfigException e) {
                String msg = localStrings.getString("admin.server.core.mbean.config.error_locating_server_node", e.getMessage());
                throw new MBeanConfigException(msg);
            }
        }
        sLogger.log(Level.FINEST, MSG_LOG_CONF_CTX, new Object[]{this.getClass().getName(), new Long(configContext.hashCode())});
        this.m_ServerInstanceName = instanceName;
        this.m_configContext = configContext;
        this.m_MBeanNamingInfo = namingInfo;
        this.m_BasePath = namingInfo.getXPath();
    }

    public void initialize(String mbeanType, String[] locations) throws MBeanConfigException {
        ConfigMBeanNamingInfo namingInfo;
        try {
            namingInfo = new ConfigMBeanNamingInfo(mbeanType, locations);
        }
        catch (MBeanConfigException mce) {
            throw mce;
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
        this.initialize(namingInfo);
    }

    public void initialize(String dottedName) throws MBeanConfigException {
        ConfigMBeanNamingInfo namingInfo;
        try {
            namingInfo = new ConfigMBeanNamingInfo(dottedName);
        }
        catch (MBeanConfigException mce) {
            throw mce;
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
        this.initialize(namingInfo);
    }

    public void initialize(ObjectName objectName) throws MBeanConfigException {
        ConfigMBeanNamingInfo namingInfo;
        try {
            namingInfo = new ConfigMBeanNamingInfo(objectName);
        }
        catch (MBeanConfigException mce) {
            throw mce;
        }
        catch (Exception e) {
            throw new MBeanConfigException(e.getMessage());
        }
        this.initialize(namingInfo);
    }

    public void setDescriptions(String[][] attrsMapList, String[] attrDescriptions, String[] operDescriptions) throws MBeanConfigException {
        this.m_Attrs = this.createAttrsDescriptors(attrsMapList);
        MBeanEasyConfig easyConfig = new MBeanEasyConfig(this.getClass(), attrDescriptions, operDescriptions, null);
        this.m_MBeanInfo = easyConfig.getMBeanInfo();
    }

    public void setAdminContext(AdminContext adminContext) {
        this.m_AdminContext = adminContext;
    }

    public AdminContext getAdminContext() {
        return this.m_AdminContext;
    }

    public ConfigContext getConfigContext() {
        return this.m_configContext;
    }

    public String getServerInstanceName() {
        return this.m_ServerInstanceName;
    }

    public ConfigMBeanNamingInfo getConfigMBeanNamingInfo() {
        return this.m_MBeanNamingInfo;
    }

    public String getBasePath() {
        return this.m_BasePath;
    }

    public ConfigBean getBaseConfigBean() {
        try {
            return this.getConfigBeanByXPath(this.m_BasePath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this.m_MBeanInfo;
    }

    public ConfigBean getConfigBean(String externalName) {
        AttrDescriptor descr = this.getDescriptor(externalName);
        try {
            return descr.getConfigBean();
        }
        catch (Exception e) {
            return null;
        }
    }

    public ConfigBean getConfigBeanByXPath(String xPath) throws ConfigException {
        sLogger.log(Level.FINEST, MSG_GET_CONFBEANBYXPATH, xPath);
        return ConfigBeansFactory.getConfigBeanByXPath(this.m_configContext, xPath);
    }

    public Object getAttribute(String externalName) throws MBeanException, AttributeNotFoundException {
        sLogger.log(Level.FINEST, MSG_BASE_GET_ATTRIBUTE, externalName);
        MBeanAttributeInfo ai = this.getAttrInfo(externalName);
        boolean isProperty = externalName.startsWith("property.");
        if (ai == null && !isProperty) {
            String msg = localStrings.getString("admin.server.core.mbean.config.attribute_not_defined", externalName);
            throw new AttributeNotFoundException(msg);
        }
        if (ai != null && !ai.isReadable()) {
            String msg = localStrings.getString("admin.server.core.mbean.config.attribute_not_readable", externalName);
            throw new AttributeNotFoundException(msg);
        }
        try {
            if (isProperty) {
                return this.getPropertyElementValue(externalName.substring("property.".length()));
            }
            AttrDescriptor descr = this.getDescriptor(externalName);
            ConfigBean bean = this.getConfigBean(externalName);
            String value = null;
            if (descr.isElement()) {
                String msg = localStrings.getString("admin.server.core.mbean.config.getattribute_not_implemented_for_xml");
                throw new MBeanException(new MBeanConfigException(msg));
            }
            value = bean.getRawAttributeValue(descr.getAttributeName());
            sLogger.log(Level.FINEST, MSG_BASE_GOT_ATTRIBUTE, new Object[]{externalName, value, MBeanEasyConfig.convertStringValueToProperType(value, ai.getType())});
            return MBeanEasyConfig.convertStringValueToProperType(value, ai.getType());
        }
        catch (MBeanConfigException e) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getattribute_attribute_exception", externalName, e.getMessage());
            throw new MBeanException(new MBeanConfigException(msg));
        }
    }

    public Object getPropertyElementValue(String propertyName) throws MBeanException, AttributeNotFoundException {
        ElementProperty prop;
        sLogger.log(Level.FINEST, MSG_BASE_GET_PROPERTY, propertyName);
        ConfigBean baseBean = this.getBaseConfigBean();
        Class<?> cl = baseBean.getClass();
        try {
            Method method = cl.getDeclaredMethod("getElementPropertyByName", Class.forName("java.lang.String"));
            prop = (ElementProperty)method.invoke((Object)baseBean, propertyName);
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getattribute.undefined_properties_in_base_element", propertyName);
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (prop == null) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getattribute_properties_not_found_in_base_element", propertyName);
            throw new MBeanException(new MBeanConfigException(msg));
        }
        return prop.getValue();
    }

    public void setPropertyElementValue(Attribute attr, boolean bAllowsEmptyValue) throws MBeanException, AttributeNotFoundException {
        ElementProperty prop;
        Method method;
        String propertyName = attr.getName();
        String value = (String)attr.getValue();
        sLogger.log(Level.FINEST, MSG_BASE_SET_PROPERTY, new Object[]{propertyName, value});
        ConfigBean baseBean = this.getBaseConfigBean();
        Class<?> cl = baseBean.getClass();
        try {
            method = cl.getDeclaredMethod("getElementPropertyByName", Class.forName("java.lang.String"));
            prop = (ElementProperty)method.invoke((Object)baseBean, propertyName);
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.mbean.config.setattribute_undefined_properties_in_base_element", propertyName);
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (prop == null && value != null && (bAllowsEmptyValue || !value.equals(ELEMENT_CONTENT))) {
            prop = new ElementProperty();
            prop.setName(propertyName);
            prop.setValue(value);
            try {
                method = cl.getDeclaredMethod("addElementProperty", prop.getClass());
                method.invoke((Object)baseBean, prop);
            }
            catch (Exception e) {
                String msg = localStrings.getString("admin.server.core.mbean.config.setproperty_invoke_error", propertyName);
                throw new MBeanException(new MBeanConfigException(msg));
            }
        } else if (value == null || !bAllowsEmptyValue && value.equals(ELEMENT_CONTENT)) {
            try {
                method = cl.getDeclaredMethod("removeElementProperty", prop.getClass());
                method.invoke((Object)baseBean, prop);
            }
            catch (Exception e) {
                String msg = localStrings.getString("admin.server.core.mbean.config.setproperty_could_not_remove_propery", propertyName);
                throw new MBeanException(new MBeanConfigException(msg));
            }
        } else {
            prop.setValue(value);
        }
        try {
            this.m_configContext.flush();
        }
        catch (ConfigException e) {
            throw new MBeanException(new MBeanConfigException(e.getMessage()));
        }
    }

    public Object getDefaultAttributeValue(String externalName) throws AttributeNotFoundException, MBeanConfigException {
        sLogger.log(Level.FINEST, MSG_BASE_GET_DEF_ATTR_VALUE, externalName);
        MBeanAttributeInfo ai = this.getAttrInfo(externalName);
        if (ai == null) {
            String msg = localStrings.getString("admin.server.core.mbean.config.getdefaultattribute_undefined_attribute", externalName);
            throw new AttributeNotFoundException(msg);
        }
        AttrDescriptor descr = this.getDescriptor(externalName);
        String value = descr.getDefaultValue();
        return MBeanEasyConfig.convertStringValueToProperType(value, ai.getType());
    }

    public void setAttribute(Attribute attr) throws MBeanException, AttributeNotFoundException {
        String externalName = attr.getName();
        Object value = attr.getValue();
        sLogger.log(Level.FINEST, MSG_BASE_SET_ATTRIBUTE, new Object[]{externalName, value});
        MBeanAttributeInfo ai = this.getAttrInfo(externalName);
        boolean isProperty = externalName.startsWith("property.");
        if (ai == null && !isProperty) {
            String msg = localStrings.getString("admin.server.core.mbean.config.setattribute_undefined_attribute", externalName);
            throw new AttributeNotFoundException(msg);
        }
        if (ai != null && !ai.isWritable()) {
            String msg = localStrings.getString("admin.server.core.mbean.config.setattribute_attribute_not_writable", externalName);
            throw new MBeanException(new MBeanConfigException(msg));
        }
        try {
            if (isProperty) {
                AttrDescriptor descr;
                boolean bAllowsEmptyValue = true;
                if (ai != null && (descr = this.getDescriptor(externalName)) != null) {
                    bAllowsEmptyValue = descr.isEmptyValueAllowed();
                }
                this.setPropertyElementValue(new Attribute(externalName.substring("property.".length()), value), bAllowsEmptyValue);
                return;
            }
            AttrDescriptor descr = this.getDescriptor(externalName);
            ConfigBean bean = this.getConfigBean(externalName);
            if (descr.isElement()) {
                String msg = localStrings.getString("admin.server.core.mbean.config.getattribute_not_implemented_for_xml");
                throw new MBeanException(new MBeanConfigException(msg));
            }
            if (value == null || value.equals(ELEMENT_CONTENT) && !descr.isEmptyValueAllowed()) {
                bean.setAttributeValue(descr.getAttributeName(), null);
            } else {
                bean.setAttributeValue(descr.getAttributeName(), value.toString());
            }
            this.m_configContext.flush();
        }
        catch (ConfigException e) {
            String msg = localStrings.getString("admin.server.core.mbean.config.setAttribute_exception_for_externalname_basexpath", externalName, this.m_BasePath, e.getMessage());
            throw new MBeanException(new MBeanConfigException(msg));
        }
    }

    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList attrs = new AttributeList();
        for (int i = 0; i < attributeNames.length; ++i) {
            String[] names;
            if (attributeNames[i].length() == 0) {
                names = this.getAllAttributeNames();
                if (names == null) continue;
                attrs.addAll(this.getAttributes(names));
                continue;
            }
            if (attributeNames[i].equals("property.")) {
                names = this.getAllPropertyNames(true);
                if (names == null) continue;
                attrs.addAll(this.getAttributes(names));
                continue;
            }
            try {
                Object value = this.getAttribute(attributeNames[i]);
                attrs.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (MBeanException ce) {
                attrs.add(new Attribute(attributeNames[i], null));
                continue;
            }
            catch (AttributeNotFoundException ce) {
                attrs.add(new Attribute(attributeNames[i], null));
                continue;
            }
            catch (NullPointerException npe) {
                attrs.add(new Attribute(attributeNames[i], null));
            }
        }
        return attrs;
    }

    public AttributeList setAttributes(AttributeList attrList) {
        AttributeList attrs = new AttributeList();
        Iterator it = attrList.iterator();
        while (it.hasNext()) {
            try {
                Attribute attribute = (Attribute)it.next();
                this.setAttribute(attribute);
                attrs.add(attribute);
            }
            catch (MBeanException mbe) {
            }
            catch (AttributeNotFoundException anfe) {
            }
            catch (NullPointerException npe) {}
        }
        return attrs;
    }

    public Object invoke(String methodName, Object[] methodParams, String[] methodSignature) throws MBeanException, ReflectionException {
        return super.invoke(methodName, methodParams, methodSignature);
    }

    private Hashtable createAttrsDescriptors(String[][] attrs) throws MBeanConfigException {
        Hashtable<String, AttrDescriptor> ht = new Hashtable<String, AttrDescriptor>();
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                ht.put(attrs[i][0], new AttrDescriptor(attrs[i][1]));
            }
        }
        return ht;
    }

    private AttrDescriptor getDescriptor(String externalName) {
        return (AttrDescriptor)this.m_Attrs.get(externalName);
    }

    public static String convertName(String name) {
        StringBuffer n = new StringBuffer();
        boolean up = true;
        boolean keepCase = false;
        StringCharacterIterator ci = new StringCharacterIterator(name);
        char c = ci.first();
        while (c != '\uffff') {
            if (Character.isLowerCase(c)) {
                keepCase = true;
                break;
            }
            c = ci.next();
        }
        c = ci.first();
        while (c != '\uffff') {
            if (c == '-' || c == '_') {
                up = true;
            } else {
                if (up) {
                    c = Character.toUpperCase(c);
                } else if (!keepCase) {
                    c = Character.toLowerCase(c);
                }
                n.append(c);
                up = false;
            }
            c = ci.next();
        }
        return n.toString();
    }

    private MBeanAttributeInfo getAttrInfo(String attrName) {
        if (attrName == null || this.m_MBeanInfo == null) {
            return null;
        }
        MBeanAttributeInfo[] ai = this.m_MBeanInfo.getAttributes();
        if (ai != null) {
            for (int i = 0; i < ai.length; ++i) {
                String name = ai[i].getName();
                if (!attrName.equals(ai[i].getName())) continue;
                return ai[i];
            }
        }
        return null;
    }

    private String[] getAllAttributeNames() {
        if (this.m_Attrs == null) {
            return null;
        }
        Enumeration keys = this.m_Attrs.keys();
        ArrayList list = new ArrayList();
        while (keys.hasMoreElements()) {
            list.add(keys.nextElement());
        }
        return list.toArray(new String[list.size()]);
    }

    private String[] getAllPropertyNames(boolean bAddPropertyPrefix) {
        ConfigBean baseBean = this.getBaseConfigBean();
        Class<?> cl = baseBean.getClass();
        try {
            Method method = cl.getDeclaredMethod("getElementProperty", null);
            ElementProperty[] props = (ElementProperty[])method.invoke((Object)baseBean, null);
            String[] names = new String[props.length];
            for (int i = 0; i < props.length; ++i) {
                names[i] = bAddPropertyPrefix ? "property." + props[i].getName() : props[i].getName();
            }
            return names;
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
        catch (InvocationTargetException ite) {
            return null;
        }
    }

    static Object[] MergeAttributesWithAnotherMbean(String[][] maplist1, String[] attributes1, String[][] maplist2, String[] attributes2, String relativeXPath2, String attrNamesPrefix2) {
        int size = 0;
        if (maplist1 != null) {
            size += maplist1.length;
        }
        if (maplist2 != null) {
            size += maplist2.length;
        }
        String[][] new_maplist = new String[size][];
        String[] new_attributes = new String[size];
        int i = 0;
        if (maplist1 != null) {
            for (i = 0; i < maplist1.length; ++i) {
                new_maplist[i] = (String[])maplist1[i].clone();
                new_attributes[i] = attributes1[i];
            }
        }
        if (maplist2 != null) {
            for (int j = 0; j < maplist2.length; ++j) {
                String[] mapelem = (String[])maplist2[j].clone();
                new_attributes[i + j] = attributes2[j];
                if (attrNamesPrefix2 != null) {
                    mapelem[0] = attrNamesPrefix2 + mapelem[0];
                    new_attributes[i + j] = attrNamesPrefix2 + attributes2[j].trim();
                }
                mapelem[1] = relativeXPath2 + "/" + mapelem[1];
                new_maplist[i + j] = mapelem;
            }
        }
        return new Object[]{new_maplist, new_attributes};
    }

    private static Class getConfigBeanClass(String xPath) {
        String beanName = ConfigBeansFactory.getConfigBeanNameByXPath(xPath);
        try {
            Class<?> cl = Class.forName("com.sun.enterprise.config.serverbeans." + beanName);
            return cl;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Class getImplementingClass() {
        return this.getClass();
    }

    protected Object getImplementingMBean() {
        return this;
    }

    private class AttrDescriptor {
        public String m_xPath = "";
        public String m_attributeName;
        public boolean m_bAllowsEmptyValue = false;

        public AttrDescriptor(String description) throws MBeanConfigException {
            try {
                int lastSlashIdx = description.lastIndexOf("/");
                if (description.charAt(lastSlashIdx + 1) == '@') {
                    if (description.charAt(lastSlashIdx + 2) == '@') {
                        this.m_attributeName = description.substring(lastSlashIdx + 3);
                        this.m_bAllowsEmptyValue = true;
                    } else {
                        this.m_attributeName = description.substring(lastSlashIdx + 2);
                    }
                    if (lastSlashIdx > 0) {
                        this.m_xPath = description.substring(0, lastSlashIdx);
                    }
                } else {
                    this.m_attributeName = null;
                }
            }
            catch (Throwable e) {
                String msg = localStrings.getString("admin.server.core.mbean.config.attrdescriptor_constructor_exception", description, e.getMessage());
                throw new MBeanConfigException(msg);
            }
        }

        public String getAttributeName() {
            return this.m_attributeName;
        }

        public String getXPath() {
            if (ConfigMBeanBase.this.m_BasePath == null || ConfigMBeanBase.this.m_BasePath.length() == 0 || this.m_xPath.indexOf("/") == 0) {
                return this.m_xPath;
            }
            if (this.m_xPath.length() == 0) {
                return ConfigMBeanBase.this.m_BasePath;
            }
            return ConfigMBeanBase.this.m_BasePath + "/" + this.m_xPath;
        }

        public boolean isEmptyValueAllowed() {
            return this.m_bAllowsEmptyValue;
        }

        public ConfigBean getConfigBean() throws Exception {
            return ConfigMBeanBase.this.getConfigBeanByXPath(this.getXPath());
        }

        public String getDefaultValue() {
            Class cl = ConfigMBeanBase.getConfigBeanClass(this.getXPath());
            try {
                Method method = cl.getMethod("getDefaultAttributeValue", Class.forName("java.lang.String"));
                return (String)method.invoke(null, this.m_attributeName);
            }
            catch (Exception e) {
                return null;
            }
        }

        public boolean isElement() {
            return this.m_attributeName == null;
        }
    }
}

