/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core;

import com.sun.enterprise.admin.server.core.ManualChangeManager;
import com.sun.enterprise.admin.server.core.ManualChangeStatus;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ServerManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ManualChangeTracker {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static int sleepPeriod = 120000;
    private static TrackerThread trackerThread = null;

    static void start() {
        logger.log(Level.FINE, "core.tracker_thread_starting");
        trackerThread = new TrackerThread();
        trackerThread.start();
    }

    static void stop() {
        trackerThread = null;
        logger.log(Level.FINE, "core.tracker_thread_stopping");
    }

    static /* synthetic */ int access$100() {
        return sleepPeriod;
    }

    private static class TrackerThread
    extends Thread {
        private static final int SLEEPTIME = ManualChangeTracker.access$100();

        private TrackerThread() {
        }

        public void run() {
            Thread t = Thread.currentThread();
            while (t == trackerThread) {
                try {
                    TrackerThread.sleep(SLEEPTIME);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                try {
                    String[] instanceIds = ServerManager.instance().getInstanceNames(false);
                    for (int i = 0; i < instanceIds.length; ++i) {
                        try {
                            String instanceId = instanceIds[i];
                            InstanceEnvironment ie = new InstanceEnvironment(instanceId);
                            ManualChangeStatus mcs = new ManualChangeStatus();
                            mcs.setServerXmlFileChanged(ie.hasHotXmlChanged());
                            mcs.setRealmsKeyFileChanged(ie.hasHotRealmsKeyChanged());
                            logger.log(Level.FINE, "Got Manual Change status for " + instanceId);
                            logger.log(Level.FINEST, "-------------------------------------");
                            logger.log(Level.FINEST, mcs.toString());
                            logger.log(Level.FINEST, "------------------------------------");
                            ManualChangeManager.addManualChangeStatus(instanceId, mcs);
                            TrackerThread.sleep(2000L);
                            continue;
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "core.error_getting_manual_changes", e);
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

