/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.runtime;

import com.sun.enterprise.admin.BaseAdminMBean;
import com.sun.enterprise.admin.MBeanHelper;
import com.sun.enterprise.admin.config.ConfigMBeanHelper;
import com.sun.enterprise.admin.config.ManagedConfigBean;
import com.sun.enterprise.admin.meta.MBeanRegistry;
import com.sun.enterprise.admin.meta.MBeanRegistryFactory;
import com.sun.enterprise.admin.runtime.ManagedJsr77MdlBean;
import com.sun.enterprise.config.ConfigBean;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class BaseRuntimeMBean
extends BaseAdminMBean
implements MBeanRegistration {
    private ManagedConfigBean mcb = null;
    private ManagedJsr77MdlBean mrb = null;
    protected MBeanRegistry m_registry = MBeanRegistryFactory.getRuntimeMBeanRegistry();

    public void setManagedResource(Object resource, String type) throws InstanceNotFoundException, MBeanException, RuntimeOperationsException {
        if (resource == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Managed resource is null"), "Managed resource is null");
        }
        if ("ConfigBeanReference".equalsIgnoreCase(type)) {
            if (!(resource instanceof ConfigBean)) {
                throw new RuntimeOperationsException(new ClassCastException("Managed resource is not a ConfigBean"), "Managed resource is not a ConfigBean");
            }
            this.mcb = new ManagedConfigBean(this, (ConfigBean)resource, this.m_registry);
        } else if ("Jsr77ModelBeanReference".equalsIgnoreCase(type)) {
            this.mrb = new ManagedJsr77MdlBean(this, resource);
        } else {
            super.setManagedResource(resource, type);
        }
    }

    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        ModelMBeanAttributeInfo attrInfo = (ModelMBeanAttributeInfo)MBeanHelper.findMatchingAttributeInfo((MBeanInfo)((Object)this.info), name);
        if (attrInfo == null) {
            throw new AttributeNotFoundException();
        }
        try {
            return super.getAttribute(name);
        }
        catch (Exception e) {
            if (this.mrb != null) {
                try {
                    return this.mrb.getAttribute(attrInfo, name);
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if (this.mcb != null) {
                try {
                    return this.mcb.getAttribute(attrInfo, name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new AttributeNotFoundException();
        }
    }

    public AttributeList getAttributes(String[] attributeNames) {
        AttributeList list = new AttributeList();
        if (attributeNames != null) {
            for (int i = 0; i < attributeNames.length; ++i) {
                try {
                    Object value = this.getAttribute(attributeNames[i]);
                    list.add(new Attribute(attributeNames[i], value));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return list;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        ModelMBeanAttributeInfo attrInfo = (ModelMBeanAttributeInfo)MBeanHelper.findMatchingAttributeInfo((MBeanInfo)((Object)this.info), attribute.getName());
        if (attrInfo == null) {
            throw new AttributeNotFoundException();
        }
        try {
            super.setAttribute(attribute);
            return;
        }
        catch (Exception e) {
            if (this.mrb != null) {
                try {
                    this.mrb.setAttribute(attrInfo, attribute);
                    return;
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            if (this.mcb != null) {
                try {
                    this.mcb.setAttribute(attrInfo, attribute);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public AttributeList setAttributes(AttributeList list) {
        if (list == null || list.size() <= 0) {
            return null;
        }
        AttributeList listRes = new AttributeList();
        for (int i = 0; i < list.size(); ++i) {
            try {
                Attribute attr = (Attribute)list.get(i);
                this.setAttribute(attr);
                listRes.add(attr);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return listRes;
    }

    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        ModelMBeanOperationInfo opInfo = (ModelMBeanOperationInfo)MBeanHelper.findMatchingOperationInfo((MBeanInfo)((Object)this.info), name, signature);
        if (opInfo == null) {
            String msg = this._localStrings.getString("admin.server.core.mbean.config.base.operation_is_not_found", this.mbeanType, name);
            throw new MBeanException(new ServiceNotFoundException(msg), msg);
        }
        try {
            Object ret = MBeanHelper.invokeOperationInBean(opInfo, this, params);
            if (ret != MBeanHelper.INVOKE_ERROR_SIGNAL_OBJECT) {
                return ret;
            }
            if (this.mrb != null && (ret = this.mrb.invokeOperation(opInfo, params, signature)) != MBeanHelper.INVOKE_ERROR_SIGNAL_OBJECT) {
                return ret;
            }
            if (this.mcb != null && (ret = this.mcb.invokeOperation(opInfo, params, signature)) != MBeanHelper.INVOKE_ERROR_SIGNAL_OBJECT) {
                return ret;
            }
        }
        catch (MBeanException mbe) {
            throw mbe;
        }
        catch (Exception e) {
            String msg = this._localStrings.getString("admin.server.core.mbean.runtime.base.invoke_error", this.mbeanType, name);
            throw MBeanHelper.extractAndWrapTargetException(e, msg);
        }
        return super.invoke(name, params, signature);
    }

    protected ObjectName createChildElementByType(String childElementName, Attribute[] attrs) throws Exception {
        return this.createChildElementByType(childElementName, attrs, true, false);
    }

    protected ObjectName createChildElementByType(String childElementName, Attribute[] attrs, boolean bSkipNullValued) throws Exception {
        return this.createChildElementByType(childElementName, attrs, bSkipNullValued, false);
    }

    protected ObjectName createChildElementByType(String childElementName, Attribute[] attrs, boolean bSkipNullValued, boolean bOnlyOne) throws Exception {
        AttributeList list = new AttributeList();
        for (int i = 0; i < attrs.length; ++i) {
            if (bSkipNullValued && attrs[i].getValue() == null) continue;
            list.add(attrs[i]);
        }
        ConfigBean bean = this.mcb.createChildByType(childElementName, list, null, bOnlyOne);
        return ConfigMBeanHelper.getChildObjectName(this.m_registry, this.info, bean);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

