/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.config.ConfigMBeanHelper;
import com.sun.enterprise.admin.selfmanagement.event.ManagementRulesMBeanHelper;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Action;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Event;
import com.sun.enterprise.config.serverbeans.ManagementRule;
import com.sun.enterprise.config.serverbeans.ManagementRules;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementRulesMBean
extends BaseConfigMBean {
    public ObjectName createManagementRule(String ruleName, Boolean bRuleEnabled, String ruleDescription, String eventType, String eventLevel, Boolean eventRecordEvent, String eventDescription, Properties eventProperties, String actionMbeanName) throws Exception {
        ManagementRule newRule = new ManagementRule();
        newRule.setName(ruleName);
        if (ruleDescription != null) {
            newRule.setDescription(ruleDescription);
        }
        if (bRuleEnabled != null) {
            newRule.setEnabled(bRuleEnabled);
        }
        Event event = new Event();
        event.setType(eventType);
        if (eventRecordEvent != null) {
            event.setRecordEvent(eventRecordEvent);
        }
        if (eventLevel != null) {
            event.setLevel(eventLevel);
        }
        if (eventDescription != null) {
            event.setDescription(eventDescription);
        }
        if (null != eventProperties) {
            Enumeration<Object> keys = eventProperties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                ElementProperty prop = new ElementProperty();
                prop.setName(key);
                prop.setValue((String)eventProperties.get(key));
                event.addElementProperty(prop);
            }
        }
        newRule.setEvent(event);
        if (actionMbeanName != null) {
            Action action = new Action();
            action.setActionMbeanName(actionMbeanName);
            newRule.setAction(action);
        }
        ManagementRules rules = (ManagementRules)this.getBaseConfigBean();
        rules.addManagementRule(newRule);
        return ConfigMBeanHelper.getChildObjectName(this.m_registry, this.info, newRule);
    }

    public void addActionToManagementRule(String ruleName, String actionMbeanName) throws ConfigException {
        ManagementRules rules = (ManagementRules)this.getBaseConfigBean();
        ManagementRule rule = rules.getManagementRuleByName(ruleName);
        Action action = new Action();
        action.setActionMbeanName(actionMbeanName);
        rule.setAction(action);
    }

    public List<String> getAllActionMBeans(boolean enabled) throws ConfigException {
        return ManagementRulesMBeanHelper.getAllActionMBeans(enabled);
    }

    public List<String> getEventTypes(boolean isEE) {
        return ManagementRulesMBeanHelper.getEventTypes(isEE);
    }

    public List<String> getEventProperties(String eventType) {
        return ManagementRulesMBeanHelper.getEventProperties(eventType);
    }

    public List<String> getEventPropertyValues(String eventType, String propertyName) throws ConfigException {
        return ManagementRulesMBeanHelper.getEventPropertyValues(eventType, propertyName);
    }

    List<String> getAllNotificationEmitterMbeans(boolean enabled) throws ConfigException {
        return ManagementRulesMBeanHelper.getAllNotificationEmitterMbeans(enabled);
    }

    public Set<ObjectName> getRegisteredMBeans(String filter) throws MalformedObjectNameException {
        return ManagementRulesMBeanHelper.getRegisteredMBeans(filter);
    }

    public List<String> getAttributes(ObjectName objName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return ManagementRulesMBeanHelper.getAttributes(objName);
    }

    public List<String> getMBeanAttributes(String objectNameStr) throws MalformedObjectNameException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        return ManagementRulesMBeanHelper.getMBeanAttributes(objectNameStr);
    }

    public List<String> getNotificationTypes(ObjectName objName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        return ManagementRulesMBeanHelper.getNotificationTypes(objName);
    }

    public List<String> getNotificationTypes(String objectNameStr) throws MalformedObjectNameException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        return ManagementRulesMBeanHelper.getNotificationTypes(objectNameStr);
    }

    public List<String> getAttributes(String dottedName) {
        return null;
    }

    public List<String> getDottedNames(String dottedName) {
        return null;
    }
}

